#include "_shared.fx"

float4x4 wMatrix 	: World
<
	string UIWidget="None";
>;

Texture2D<float4> cubeTex;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	uint instance		: SV_InstanceID;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	uint split : TEXTURE0;
};

struct GS_OUTPUT
{
    float4 Position	: SV_POSITION;
	uint rtIndex : SV_RenderTargetArrayIndex;
};

struct PS_OUTPUT
{
	float depth : SV_Depth;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	float curTime = min(time,180.0f);
	float4 disp = cubeTex.Load(int3(In.instance/3,0,0));
	In.Position *= max(0.0f,abs(sin(disp.w*16.0f-(curTime-3.2f)*0.5f))-0.5f)*1.0f;
	In.Position += disp.xyz;
	
    float4x4 wvpMatrix = mul(mul(wMatrix,lvMatrix),pMatrices[In.instance%3]);
    Out.Position = mul(float4(In.Position,1.0f), wvpMatrix);
	Out.split = In.instance%3;
    return Out;
}

[maxvertexcount(3)]
void RenderSceneGS( triangle VS_OUTPUT In[3], inout TriangleStream<GS_OUTPUT> triStream )
{
	GS_OUTPUT Out;
	Out.rtIndex = In[0].split;
	Out.Position = In[0].Position;
	triStream.Append(Out);
	Out.Position = In[1].Position;
	triStream.Append(Out);
	Out.Position = In[2].Position;
	triStream.Append(Out);
	triStream.RestartStrip();
}

technique10 RenderDepth
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( CompileShader( gs_4_0, RenderSceneGS() ) );
	SetPixelShader( NULL );

	SetDepthStencilState( Depth, 0 );
	SetRasterizerState( NotMultisampled );
    }
}