#include "_shared.fx"

const float gaussianCoefs[7] = { 
0.036634443338442654485719345599775f,
0.11128549298842362175553017858187f,
0.21675429864898149448661500349083f,
0.27069427735675071601741647481243f,
0.21675429864898149448661500349083f,
0.11128549298842362175553017858187f,
0.036634443338442654485719345599775f
};

Texture2D texture0;

struct VS_INPUT
{
    float3 vPos 	: POSITION;
	float2 uvCoord 	: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float4 uvCoord[4] : TEXCOORD0;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In, uniform float2 direction )
{
    VS_OUTPUT Out;
    
	uint width, height;
	texture0.GetDimensions(width,height);
	float dx = 1.0f/width;
	float dy = 1.0f/height;
	
    Out.Position = float4(In.vPos,1.0f);
	Out.uvCoord[0].xy = In.uvCoord.xy-3.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[0].zw = In.uvCoord.xy+3.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[1].xy = In.uvCoord.xy-2.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[1].zw = In.uvCoord.xy+2.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[2].xy = In.uvCoord.xy-1.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[2].zw = In.uvCoord.xy+1.0f*float2(dx*direction.x,dy*direction.y);
	Out.uvCoord[3].xy = In.uvCoord.xy;
	Out.uvCoord[3].zw = float2(0.0f,0.0f);
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	float4 finalColor = 0.0f;
	for( int i = 0; i < 3; i++ )
	{
		finalColor += texture0.Sample(LinearSampler,In.uvCoord[i].xy)*gaussianCoefs[i];
		finalColor += texture0.Sample(LinearSampler,In.uvCoord[i].zw)*gaussianCoefs[i];
	}
	finalColor += texture0.Sample(LinearSampler,In.uvCoord[3].xy)*gaussianCoefs[3];
	
	Out.finalColor = finalColor;

    return Out;
}


technique10 Horizontal
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS(float2(1.5f,0.0f)) ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( NoBlending, float4(0,0,0,0), 0xffffffff );
    }
}
technique10 Vertical
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS(float2(0.0f,1.5f)) ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( AdditiveBlending, float4(0,0,0,0), 0xffffffff );
    }
}