#include "_shared.fx"

float4x4 wMatrix 	: World
<
	string UIWidget="None";
>;
float4x4 wvMatrix	: WorldView
<
	string UIWidget="None";
>;

float4x4 wvpMatrix 	: WorldViewProjection
<
	string UIWidget="None";
>;

float4 g_MaterialAmbientColor
<
    string UIName =  "Material Ambient";
    string UIWidget = "Color";
> = {0.1f,0.1f,0.1f,1.0f};

float4 g_MaterialDiffuseColor
<
    string UIName =  "Material Diffuse";
    string UIWidget = "Color";
> = { 1.0f, 1.0f, 1.0f, 0.0f };

float shadowFactor
<
	string UIName = "Shadow Influence";
> = 0.7f;

Texture2D<float3> colors;
Texture2D<float4> cubeTex;

struct VS_INPUT
{
    float3 vPos : POSITION;
	uint   instance : SV_INSTANCEID;
    float3 normal : NORMAL;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
    float3 lightDir	: TEXCOORD0;
    float3 normal	: TEXCOORD1;
	float3 depth	: TEXCOORD2;
	float4 LampPos[3] : TEXCOORD3;
	float3 diffuse	: TEXCOORD6;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
 
	float curTime = min(time,180.0f);   
	float4 disp = cubeTex.Load(int3(In.instance,0,0));
	In.vPos *= max(0.0f,abs(sin(disp.w*16.0f-(curTime-3.2f)*0.5f))-0.5f)*1.0f;
	In.vPos += disp.xyz;
    float4x4 wvLampMatrix = mul(wMatrix,lvMatrix);
	
	float4 lampSpace = mul(float4(In.vPos,1.0f),wvLampMatrix);
    float4 LampPos = mul(lampSpace,pMatrices[0]);
	Out.LampPos[0].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	LampPos = mul(lampSpace,pMatrices[1]);
	Out.LampPos[1].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	LampPos = mul(lampSpace,pMatrices[2]);
	Out.LampPos[2].xyzw = float4(0.5f*float2(LampPos.x,-LampPos.y)/LampPos.w+float2(0.5f,0.5f),LampPos.z,LampPos.w);
	
    Out.normal = mul( float4(In.normal,0.0f), wMatrix );
    float3 vWorld = mul( float4(In.vPos,1.0f), wMatrix );
    Out.lightDir = normalize(lightPos - vWorld.xyz);
    Out.Position = mul(float4(In.vPos,1.0f), wvpMatrix);
	Out.depth = float3(mul(float4(In.vPos,1.0f), wvMatrix).z,dot(Out.lightDir,Out.normal), abs(Out.Position.x)*1544141.0f+abs(Out.Position.y)*348866.0f);
	Out.diffuse = colors.SampleLevel(PointSampler,float2(disp.w,0.0f),0);
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;
	
	float factor = 0.0f;
	if( In.depth.y > 0.0f )
	{
		int i;
		for( i = 0; i < 2; i++ )
			if( In.depth.x < splitPlanes[i] )
				break;
		
		uint screenPs = uint(In.depth.z)%256;
		float pxDepth = In.LampPos[i].z/In.LampPos[i].w + depthBias;
		
		for(int j =0; j<16; j++ )
		{
			float2 offset = noiseTex.Load(int3(j,screenPs,0)).xy;
			factor += shadowmap.SampleLevel(ShadowSampler, float3(In.LampPos[i].xy+offset,i), 0).x>pxDepth?0.0625f:0.0f;
		}
	}
	
	In.normal = normalize( In.normal );
	In.lightDir = normalize( In.lightDir );
	float dif = max( 0.0f, dot( In.normal, In.lightDir ) )*lerp(1.0f,factor,shadowFactor);
	float3 finalColor = In.diffuse*dif + g_MaterialAmbientColor.rgb;
	Out.finalColor = float4(finalColor,1.0f);//float4(pow( finalColor, 1/2.2f ),1.0f);
	
    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );

	SetDepthStencilState( Depth, 0 );
	SetRasterizerState( Multisampled );
    }
}