#include "_shared.fx"

Texture2D<float4> bubbleTexture;
float4x4 wvMatrix 	: WorldView;
float4x4 wMatrix 	: World;

struct VS_INPUT
{
    float3 vPos : POSITION;
	float3 normal : NORMAL;
	float2 uvCoord : TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float3 normal : NORMAL;
	float2 uvCoord : TEXCOORD0;
	float3 lightDir : TEXCOORD1;
	float3 viewDir : TEXCOORD2;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
	In.vPos.z = In.vPos.z+12.7f-time*0.16f;
	In.vPos.xy = In.vPos.xy*pow((1.0f+In.vPos.z*0.3f),3.0f);
	
	float angle = pow(-In.vPos.z,3.5f);
	float2x2 rotMat = { cos(angle), -sin(angle), sin(angle), cos(angle) };
	In.vPos.xy = mul(rotMat,In.vPos.xy);
	float fac = max(saturate(-In.vPos.z),0.6f);
	float3 wPos = mul(float4(In.vPos,1.0f),wMatrix);
    float4 position = mul(float4(In.vPos,1.0f), wvMatrix);
	position.xy += In.normal.xy*0.03f*fac;
	Out.Position = mul( position,pMatrix );
	Out.uvCoord = In.uvCoord;
	Out.lightDir = lightPos-wPos;
	Out.normal = mul(float4(In.normal,0.0f),wMatrix);
	Out.normal.z = In.normal.z*sign(In.normal.z*Out.lightDir.z);
	Out.viewDir = cameraPos - wPos;
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;
	float3 uniNormal = normalize(In.normal);
	float3 uniDir = normalize(In.lightDir);
	float3 uniCamera = normalize(In.viewDir);
	float specular = pow(max(0.0f,dot(uniCamera,reflect(uniNormal,-uniDir))),16.0f);
	float dotProduct = saturate(max(0.0f,dot(uniNormal,uniDir))+0.1f)*0.5f;
	//float specular = pow(dot(reflect(uniDir,uniNormal),uniDir),4.0f);
	Out.finalColor = bubbleTexture.Sample(LinearSampler,In.uvCoord).a*(dotProduct+specular);
	
    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( AdditiveBlending, float4(0,0,0,0), 0xffffffff );
    }
}