/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.sun.opengl.util.BufferUtil;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.core.PApplet;
import processing.core.PGraphics3D;
import processing.core.PImage;

public class PGraphicsOpenGL
extends PGraphics3D {
    protected GLDrawable drawable;
    protected GLContext context;
    public GL gl;
    public GLU glu;
    protected float[] projectionFloats;
    protected GLUtessellator tobj;
    protected TessCallback tessCallback;
    protected FloatBuffer lightBuffer;
    protected FloatBuffer colorBuffer;
    protected FloatBuffer zeroBuffer;
    protected IntBuffer pixelBuffer;
    public static boolean BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private float[] ctm;
    static int maxTextureSize;
    int[] deleteQueue = new int[10];
    int deleteQueueCount = 0;
    IntBuffer getsetBuffer = BufferUtil.newIntBuffer((int)1);

    public PGraphicsOpenGL(int n, int n2, PApplet pApplet) {
        super(n, n2, pApplet);
        this.glu = new GLU();
        this.tobj = this.glu.gluNewTess();
        this.tessCallback = new TessCallback();
        this.glu.gluTessCallback(this.tobj, 100100, (GLUtessellatorCallback)this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100102, (GLUtessellatorCallback)this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100101, (GLUtessellatorCallback)this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100105, (GLUtessellatorCallback)this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100103, (GLUtessellatorCallback)this.tessCallback);
        this.lightBuffer = BufferUtil.newFloatBuffer((int)4);
        this.lightBuffer.put(3, 1.0f);
        this.lightBuffer.rewind();
    }

    public PGraphicsOpenGL(int n, int n2) {
        super(n, n2, null);
    }

    protected void allocate() {
        if (this.context == null) {
            GLCapabilities gLCapabilities = new GLCapabilities();
            if (this.hints[0]) {
                gLCapabilities.setSampleBuffers(true);
                gLCapabilities.setNumSamples(2);
            } else if (this.hints[1]) {
                gLCapabilities.setSampleBuffers(true);
                gLCapabilities.setNumSamples(4);
            }
            this.drawable = GLDrawableFactory.getFactory().getGLDrawable((Object)this.parent, gLCapabilities, null);
            this.context = this.drawable.createContext(null);
            this.gl = this.context.getGL();
            this.settingsInited = false;
        } else {
            System.out.println("PGraphicsOpenGL.allocate() again for " + this.width + " " + this.height);
            this.reapplySettings();
        }
    }

    public void hint(int n) {
        boolean bl = this.hints[0];
        boolean bl2 = this.hints[1];
        super.hint(n);
        if (n == 5) {
            this.gl.glDisable(2929);
        } else if (n == 0) {
            if (!bl) {
                this.releaseContext();
                this.context.destroy();
                this.context = null;
                this.allocate();
                throw new PApplet.RendererChangeException();
            }
        } else if (n == 1 && !bl2) {
            this.releaseContext();
            this.context.destroy();
            this.context = null;
            this.allocate();
            throw new PApplet.RendererChangeException();
        }
    }

    public void unhint(int n) {
        this.hints[n] = false;
        if (n == 5) {
            this.gl.glEnable(2929);
        }
    }

    public GLContext getContext() {
        return this.context;
    }

    private void detainContext() {
        try {
            while (this.context.makeCurrent() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void releaseContext() {
        this.context.release();
    }

    public boolean canDraw() {
        return this.parent.isDisplayable();
    }

    public void beginDraw() {
        if (this.drawable != null) {
            this.drawable.setRealized(this.parent.isDisplayable());
            if (!this.parent.isDisplayable()) {
                return;
            }
            this.drawable.setRealized(true);
            this.detainContext();
        }
        super.beginDraw();
        this.report("top beginDraw()");
        this.gl.glDisable(2896);
        for (int i = 0; i < 8; ++i) {
            this.gl.glDisable(16384 + i);
        }
        this.gl.glMatrixMode(5889);
        if (this.projectionFloats == null) {
            this.projectionFloats = new float[]{this.projection.m00, this.projection.m10, this.projection.m20, this.projection.m30, this.projection.m01, this.projection.m11, this.projection.m21, this.projection.m31, this.projection.m02, this.projection.m12, this.projection.m22, this.projection.m32, this.projection.m03, this.projection.m13, this.projection.m23, this.projection.m33};
        } else {
            this.projectionFloats[0] = this.projection.m00;
            this.projectionFloats[1] = this.projection.m10;
            this.projectionFloats[2] = this.projection.m20;
            this.projectionFloats[3] = this.projection.m30;
            this.projectionFloats[4] = this.projection.m01;
            this.projectionFloats[5] = this.projection.m11;
            this.projectionFloats[6] = this.projection.m21;
            this.projectionFloats[7] = this.projection.m31;
            this.projectionFloats[8] = this.projection.m02;
            this.projectionFloats[9] = this.projection.m12;
            this.projectionFloats[10] = this.projection.m22;
            this.projectionFloats[11] = this.projection.m32;
            this.projectionFloats[12] = this.projection.m03;
            this.projectionFloats[13] = this.projection.m13;
            this.projectionFloats[14] = this.projection.m23;
            this.projectionFloats[15] = this.projection.m33;
        }
        this.gl.glLoadMatrixf(this.projectionFloats, 0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glScalef(1.0f, -1.0f, 1.0f);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        if (this.hints[5]) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
        }
        this.gl.glDepthFunc(515);
        this.gl.glFrontFace(2304);
        this.gl.glEnable(2903);
        this.gl.glColorMaterial(1032, 5634);
        this.gl.glColorMaterial(1032, 4610);
        this.report("bot beginDraw()");
    }

    public void endDraw() {
        this.report("top endDraw()");
        if (this.hints[7]) {
            this.flush();
        }
        if (this.drawable != null) {
            this.drawable.swapBuffers();
        }
        this.report("bot endDraw()");
        if (this.drawable != null) {
            this.releaseContext();
        }
    }

    public GL beginGL() {
        this.gl.glPushMatrix();
        if (this.ctm == null) {
            this.ctm = new float[16];
        }
        this.ctm[0] = this.modelview.m00;
        this.ctm[1] = this.modelview.m10;
        this.ctm[2] = this.modelview.m20;
        this.ctm[3] = this.modelview.m30;
        this.ctm[4] = this.modelview.m01;
        this.ctm[5] = this.modelview.m11;
        this.ctm[6] = this.modelview.m21;
        this.ctm[7] = this.modelview.m31;
        this.ctm[8] = this.modelview.m02;
        this.ctm[9] = this.modelview.m12;
        this.ctm[10] = this.modelview.m22;
        this.ctm[11] = this.modelview.m32;
        this.ctm[12] = this.modelview.m03;
        this.ctm[13] = this.modelview.m13;
        this.ctm[14] = this.modelview.m23;
        this.ctm[15] = this.modelview.m33;
        this.gl.glMultMatrixf(this.ctm, 0);
        return this.gl;
    }

    public void endGL() {
        this.gl.glPopMatrix();
    }

    protected void handle_lighting() {
        super.handle_lighting();
        for (int i = this.vertex_start; i < this.vertex_end; ++i) {
            float[] fArray = this.vertices[i];
            fArray[3] = this.min(1.0f, fArray[3] + fArray[27]);
            fArray[4] = this.min(1.0f, fArray[4] + fArray[28]);
            fArray[5] = this.min(1.0f, fArray[5] + fArray[29]);
        }
    }

    protected void render_triangles() {
        this.report("render_triangles in");
        for (int i = 0; i < this.triangleCount; ++i) {
            int n;
            float[] fArray = this.vertices[this.triangles[i][1]];
            float[] fArray2 = this.vertices[this.triangles[i][2]];
            float[] fArray3 = this.vertices[this.triangles[i][3]];
            float f = this.min(1.0f, this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float f2 = this.min(1.0f, this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float f3 = this.min(1.0f, this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float f4 = this.min(1.0f, this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float f5 = this.min(1.0f, this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float f6 = this.min(1.0f, this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float f7 = this.min(1.0f, this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float f8 = this.min(1.0f, this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float f9 = this.min(1.0f, this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            if (this.raw != null) {
                this.raw.colorMode(1, 1.0f);
                this.raw.noStroke();
                this.raw.beginShape(64);
            }
            if ((n = this.triangles[i][4]) != -1) {
                this.report("before enable");
                this.gl.glEnable(3553);
                this.report("after enable");
                PImage pImage = this.textures[n];
                this.bindTexture(pImage);
                this.report("before bind");
                this.report("after bind");
                ImageCache imageCache = (ImageCache)pImage.cache;
                float f10 = (float)pImage.width / (float)imageCache.twidth;
                float f11 = (float)pImage.height / (float)imageCache.theight;
                this.gl.glBegin(4);
                this.gl.glColor4f(f, f2, f3, fArray[6]);
                this.gl.glTexCoord2f(fArray[7] * f10, fArray[8] * f11);
                this.gl.glNormal3f(fArray[17], fArray[18], fArray[19]);
                this.gl.glVertex3f(fArray[20], fArray[21], fArray[22]);
                this.gl.glColor4f(f4, f5, f6, fArray2[6]);
                this.gl.glTexCoord2f(fArray2[7] * f10, fArray2[8] * f11);
                this.gl.glNormal3f(fArray2[17], fArray2[18], fArray2[19]);
                this.gl.glVertex3f(fArray2[20], fArray2[21], fArray2[22]);
                this.gl.glColor4f(f7, f8, f9, fArray3[6]);
                this.gl.glTexCoord2f(fArray3[7] * f10, fArray3[8] * f11);
                this.gl.glNormal3f(fArray3[17], fArray3[18], fArray3[19]);
                this.gl.glVertex3f(fArray3[20], fArray3[21], fArray3[22]);
                this.gl.glEnd();
                this.report("non-binding 6");
                this.gl.glDisable(3553);
                if (this.raw == null || !(this.raw instanceof PGraphics3D)) continue;
                if (fArray[23] != 0.0f && fArray2[23] != 0.0f && fArray3[23] != 0.0f) {
                    this.raw.texture(pImage);
                    this.raw.fill(f, f2, f3, fArray[6]);
                    this.raw.vertex(fArray[20] / fArray[23], fArray[21] / fArray[23], fArray[22] / fArray[23], fArray[7] * f10, fArray[8] * f11);
                    this.raw.fill(f4, f5, f6, fArray2[6]);
                    this.raw.vertex(fArray2[20] / fArray2[23], fArray2[21] / fArray2[23], fArray2[22] / fArray2[23], fArray2[7] * f10, fArray2[8] * f11);
                    this.raw.fill(f7, f8, f9, fArray3[6]);
                    this.raw.vertex(fArray3[20] / fArray3[23], fArray3[21] / fArray3[23], fArray3[22] / fArray3[23], fArray3[7] * f10, fArray3[8] * f11);
                    continue;
                }
                if (!this.reasonablePoint(fArray[0], fArray[1], fArray[2]) || !this.reasonablePoint(fArray2[0], fArray2[1], fArray2[2]) || !this.reasonablePoint(fArray3[0], fArray3[1], fArray3[2])) continue;
                this.raw.fill(f, f2, f3, fArray[6]);
                this.raw.vertex(fArray[0], fArray[1], fArray[7] * f10, fArray[8] * f11);
                this.raw.fill(f4, f5, f6, fArray2[6]);
                this.raw.vertex(fArray2[0], fArray2[1], fArray2[7] * f10, fArray2[8] * f11);
                this.raw.fill(f7, f8, f9, fArray3[6]);
                this.raw.vertex(fArray3[0], fArray3[1], fArray3[7] * f10, fArray3[8] * f11);
                continue;
            }
            this.gl.glBegin(4);
            this.gl.glColor4f(f, f2, f3, fArray[6]);
            this.gl.glNormal3f(fArray[17], fArray[18], fArray[19]);
            this.gl.glVertex3f(fArray[20], fArray[21], fArray[22]);
            this.gl.glColor4f(f4, f5, f6, fArray2[6]);
            this.gl.glNormal3f(fArray2[17], fArray2[18], fArray2[19]);
            this.gl.glVertex3f(fArray2[20], fArray2[21], fArray2[22]);
            this.gl.glColor4f(f7, f8, f9, fArray3[6]);
            this.gl.glNormal3f(fArray3[17], fArray3[18], fArray3[19]);
            this.gl.glVertex3f(fArray3[20], fArray3[21], fArray3[22]);
            if (this.raw != null) {
                if (this.raw instanceof PGraphics3D) {
                    if (fArray[23] != 0.0f && fArray2[23] != 0.0f && fArray3[23] != 0.0f) {
                        this.raw.fill(f, f2, f3, fArray[6]);
                        this.raw.vertex(fArray[20] / fArray[23], fArray[21] / fArray[23], fArray[22] / fArray[23]);
                        this.raw.fill(f4, f5, f6, fArray2[6]);
                        this.raw.vertex(fArray2[20] / fArray2[23], fArray2[21] / fArray2[23], fArray2[22] / fArray2[23]);
                        this.raw.fill(f7, f8, f9, fArray3[6]);
                        this.raw.vertex(fArray3[20] / fArray3[23], fArray3[21] / fArray3[23], fArray3[22] / fArray3[23]);
                    }
                } else if (this.reasonablePoint(fArray[0], fArray[1], fArray[2]) && this.reasonablePoint(fArray2[0], fArray2[1], fArray2[2]) && this.reasonablePoint(fArray3[0], fArray3[1], fArray3[2])) {
                    this.raw.fill(f, f2, f3, fArray[6]);
                    this.raw.vertex(fArray[0], fArray[1]);
                    this.raw.fill(f4, f5, f6, fArray2[6]);
                    this.raw.vertex(fArray2[0], fArray2[1]);
                    this.raw.fill(f7, f8, f9, fArray3[6]);
                    this.raw.vertex(fArray3[0], fArray3[1]);
                }
            }
            this.gl.glEnd();
        }
        if (this.raw != null) {
            this.raw.endShape();
        }
        this.triangleCount = 0;
        this.report("render_triangles out");
    }

    protected boolean reasonablePoint(float f, float f2, float f3) {
        return f3 < 1.0f && f > (float)(-this.width) && f < (float)(this.width * 2) && f2 > (float)(-this.height) && f2 < (float)(this.height * 2);
    }

    public float uscale(PImage pImage) {
        ImageCache imageCache = (ImageCache)pImage.cache;
        return (float)pImage.width / (float)imageCache.twidth;
    }

    public float vscale(PImage pImage) {
        ImageCache imageCache = (ImageCache)pImage.cache;
        return (float)pImage.height / (float)imageCache.theight;
    }

    public void bindTexture(PImage pImage) {
        ImageCache imageCache = (ImageCache)pImage.cache;
        if (imageCache == null) {
            imageCache = new ImageCache();
            pImage.cache = imageCache;
            pImage.modified = true;
        }
        if (pImage.modified) {
            imageCache.rebind(pImage);
            pImage.modified = false;
        } else {
            this.gl.glBindTexture(3553, imageCache.tindex);
        }
    }

    public void render_lines() {
        this.report("render_lines in");
        int n = 0;
        for (int i = 0; i < this.pathCount; ++i) {
            float f = this.vertices[this.lines[n][1]][16];
            if (f == 0.0f) continue;
            this.gl.glLineWidth(f);
            this.gl.glBegin(3);
            if (this.raw != null) {
                this.raw.strokeWeight(f);
            }
            float[] fArray = this.vertices[this.lines[n][1]];
            this.gl.glColor4f(fArray[12], fArray[13], fArray[14], fArray[15]);
            this.gl.glVertex3f(fArray[20], fArray[21], fArray[22]);
            if (this.raw != null && fArray[15] > 1.0E-4f) {
                this.raw.colorMode(1, 1.0f);
                this.raw.noFill();
                this.raw.beginShape();
                if (this.raw instanceof PGraphics3D) {
                    if (fArray[23] != 0.0f) {
                        this.raw.stroke(fArray[12], fArray[13], fArray[14], fArray[15]);
                        this.raw.vertex(fArray[20] / fArray[23], fArray[21] / fArray[23], fArray[22] / fArray[23]);
                    }
                } else {
                    this.raw.stroke(fArray[12], fArray[13], fArray[14], fArray[15]);
                    this.raw.vertex(fArray[0], fArray[1]);
                }
            }
            for (int j = 0; j < this.pathLength[i]; ++j) {
                float[] fArray2 = this.vertices[this.lines[n][2]];
                this.gl.glColor4f(fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
                this.gl.glVertex3f(fArray2[20], fArray2[21], fArray2[22]);
                if (this.raw != null) {
                    if (this.raw instanceof PGraphics3D) {
                        if (fArray[23] != 0.0f && fArray2[23] != 0.0f) {
                            this.raw.stroke(fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
                            this.raw.vertex(fArray2[20] / fArray2[23], fArray2[21] / fArray2[23], fArray2[22] / fArray2[23]);
                        }
                    } else {
                        this.raw.stroke(fArray2[12], fArray2[13], fArray2[14], fArray2[15]);
                        this.raw.vertex(fArray2[0], fArray2[1]);
                    }
                }
                ++n;
            }
            if (this.raw != null) {
                this.raw.endShape();
            }
            this.gl.glEnd();
        }
        this.report("render_lines out");
    }

    public float textAscent() {
        if (this.textMode != 5 || this.textFontNative == null) {
            return super.textAscent();
        }
        return this.textFontNativeMetrics.getAscent();
    }

    public float textDescent() {
        if (this.textMode != 5 || this.textFontNative == null) {
            return super.textDescent();
        }
        return this.textFontNativeMetrics.getDescent();
    }

    public void textSize(float f) {
        super.textSize(f);
        if (this.textFontNative != null) {
            this.textFontNative = this.textFontNative.deriveFont(f);
            Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
            graphics2D.setFont(this.textFontNative);
            this.textFontNativeMetrics = graphics2D.getFontMetrics(this.textFontNative);
        }
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        if (this.textMode != 5 || this.textFontNative == null) {
            return super.textWidthImpl(cArray, n, n2);
        }
        Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = this.textFontNative.createGlyphVector(fontRenderContext, cArray);
        float f = 0.0f;
        for (int i = n; i < n2; ++i) {
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(i);
            f += glyphMetrics.getAdvance();
        }
        return f;
    }

    protected void textCharImpl(char c, float f, float f2) {
        if (this.textMode == 5) {
            if (this.textFontNative == null) {
                throw new RuntimeException("textMode(SHAPE) is disabled because the font \"" + this.textFont.name + "\" is not available.");
            }
            this.textCharImplShape(c, f, f2);
        } else {
            super.textCharImpl(c, f, f2);
        }
    }

    protected void textCharImplShape(char c, float f, float f2) {
        boolean bl = this.stroke;
        this.stroke = false;
        float[] fArray = new float[6];
        char[] cArray = new char[]{c};
        Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = this.textFontNative.createGlyphVector(fontRenderContext, cArray);
        Shape shape = glyphVector.getOutline();
        PathIterator pathIterator = shape.getPathIterator(null);
        this.glu.gluTessBeginPolygon(this.tobj, null);
        float f3 = 0.0f;
        float f4 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: 
                case 1: {
                    if (n == 0) {
                        this.glu.gluTessBeginContour(this.tobj);
                    }
                    double[] dArray = new double[]{f + fArray[0], f2 + fArray[1], 0.0};
                    this.glu.gluTessVertex(this.tobj, dArray, 0, (Object)dArray);
                    f3 = fArray[0];
                    f4 = fArray[1];
                    break;
                }
                case 2: {
                    float f5;
                    int n2;
                    double[] dArray;
                    for (n2 = 1; n2 < this.bezierDetail; ++n2) {
                        f5 = (float)n2 / (float)this.bezierDetail;
                        dArray = new double[]{f + this.bezierPoint(f3, fArray[0], fArray[2], fArray[2], f5), f2 + this.bezierPoint(f4, fArray[1], fArray[3], fArray[3], f5), 0.0};
                        this.glu.gluTessVertex(this.tobj, dArray, 0, (Object)dArray);
                    }
                    f3 = fArray[2];
                    f4 = fArray[3];
                    break;
                }
                case 3: {
                    float f5;
                    int n2;
                    double[] dArray;
                    for (n2 = 1; n2 < this.bezierDetail; ++n2) {
                        f5 = (float)n2 / (float)this.bezierDetail;
                        dArray = new double[]{f + this.bezierPoint(f3, fArray[0], fArray[2], fArray[4], f5), f2 + this.bezierPoint(f4, fArray[1], fArray[3], fArray[5], f5), 0.0};
                        this.glu.gluTessVertex(this.tobj, dArray, 0, (Object)dArray);
                    }
                    f3 = fArray[4];
                    f4 = fArray[5];
                    break;
                }
                case 4: {
                    this.glu.gluTessEndContour(this.tobj);
                }
            }
            pathIterator.next();
        }
        this.glu.gluTessEndPolygon(this.tobj);
        this.stroke = bl;
    }

    public void textMode(int n) {
        if (n == 5) {
            this.textMode = 5;
        } else {
            super.textMode(n);
        }
    }

    public void lights() {
        super.lights();
    }

    public void ambientLight(float f, float f2, float f3) {
        super.ambientLight(f, f2, f3);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.ambientLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.directionalLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.pointLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        super.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
        this.glLightSpotAngle(this.lightCount - 1);
        this.glLightSpotConcentration(this.lightCount - 1);
    }

    public void lightFalloff(float f, float f2, float f3) {
        super.lightFalloff(f, f2, f3);
        this.glLightFalloff(this.lightCount);
    }

    public void lightSpecular(float f, float f2, float f3) {
        super.lightSpecular(f, f2, f3);
        this.glLightSpecular(this.lightCount);
    }

    protected void lightPosition(int n, float f, float f2, float f3) {
        super.lightPosition(n, f, f2, f3);
        this.glLightPosition(n);
    }

    protected void lightDirection(int n, float f, float f2, float f3) {
        super.lightDirection(n, f, f2, f3);
        this.glLightDirection(n);
    }

    protected void glLightAmbient(int n) {
        this.lightBuffer.put(this.lightDiffuse[n]);
        this.lightBuffer.rewind();
        this.gl.glLightfv(16384 + n, 4608, this.lightBuffer);
    }

    protected void glLightNoAmbient(int n) {
        if (this.zeroBuffer == null) {
            this.zeroBuffer = BufferUtil.newFloatBuffer((int)3);
        }
        this.gl.glLightfv(16384 + n, 4608, this.zeroBuffer);
    }

    protected void glLightDiffuse(int n) {
        this.lightBuffer.put(this.lightDiffuse[n]);
        this.lightBuffer.rewind();
        this.gl.glLightfv(16384 + n, 4609, this.lightBuffer);
    }

    protected void glLightDirection(int n) {
        this.lightBuffer.put(this.lightNormal[n]);
        this.lightBuffer.rewind();
        if (this.lightType[n] == 1) {
            this.gl.glLightfv(16384 + n, 4611, this.lightBuffer);
        } else {
            this.gl.glLightfv(16384 + n, 4612, this.lightBuffer);
        }
    }

    protected void glLightEnable(int n) {
        this.gl.glEnable(16384 + n);
    }

    protected void glLightFalloff(int n) {
        this.gl.glLightf(16384 + n, 4615, this.lightFalloffConstant[n]);
        this.gl.glLightf(16384 + n, 4616, this.lightFalloffLinear[n]);
        this.gl.glLightf(16384 + n, 4617, this.lightFalloffQuadratic[n]);
    }

    protected void glLightPosition(int n) {
        this.lightBuffer.put(this.lightPosition[n]);
        this.lightBuffer.rewind();
        this.gl.glLightfv(16384 + n, 4611, this.lightBuffer);
    }

    protected void glLightSpecular(int n) {
        this.lightBuffer.put(this.lightSpecular[n]);
        this.lightBuffer.rewind();
        this.gl.glLightfv(16384 + n, 4610, this.lightBuffer);
    }

    public void glLightSpotAngle(int n) {
        this.gl.glLightf(16384 + n, 4614, this.lightSpotAngle[n]);
    }

    public void glLightSpotConcentration(int n) {
        this.gl.glLightf(16384 + n, 4613, this.lightSpotConcentration[n]);
    }

    public void strokeJoin(int n) {
        String string = "strokeJoin() not available with OPENGL";
        throw new RuntimeException(string);
    }

    public void strokeCap(int n) {
        String string = "strokeCap() not available with OPENGL";
        throw new RuntimeException(string);
    }

    private final void calcColorBuffer() {
        if (this.colorBuffer == null) {
            this.colorBuffer = BufferUtil.newFloatBuffer((int)4);
        }
        this.colorBuffer.put(0, this.calcR);
        this.colorBuffer.put(1, this.calcG);
        this.colorBuffer.put(2, this.calcB);
        this.colorBuffer.put(3, this.calcA);
        this.colorBuffer.rewind();
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5634, this.colorBuffer);
    }

    public void ambient(int n) {
        super.ambient(n);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorBuffer);
    }

    public void ambient(float f) {
        super.ambient(f);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorBuffer);
    }

    public void ambient(float f, float f2, float f3) {
        super.ambient(f, f2, f3);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorBuffer);
    }

    public void specular(int n) {
        super.specular(n);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer);
    }

    public void specular(float f) {
        super.specular(f);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer);
    }

    public void specular(float f, float f2) {
        super.specular(f, f2);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer);
    }

    public void specular(float f, float f2, float f3) {
        super.specular(f, f2, f3);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer);
    }

    public void specular(float f, float f2, float f3, float f4) {
        super.specular(f, f2, f3, f4);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer);
    }

    public void emissive(int n) {
        super.emissive(n);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorBuffer);
    }

    public void emissive(float f) {
        super.emissive(f);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorBuffer);
    }

    public void emissive(float f, float f2, float f3) {
        super.emissive(f, f2, f3);
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorBuffer);
    }

    public void shininess(float f) {
        super.shininess(f);
        this.gl.glMaterialf(1032, 5633, f);
    }

    public void background(PImage pImage) {
        this.clear();
        this.set(0, 0, pImage);
    }

    public void clear() {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
        this.clearRaw();
    }

    public void smooth() {
        this.gl.glEnable(32925);
        this.gl.glEnable(2832);
        this.gl.glEnable(2848);
        this.gl.glEnable(2881);
        this.smooth = true;
    }

    public void noSmooth() {
        this.gl.glDisable(32925);
        this.gl.glDisable(2832);
        this.gl.glDisable(2848);
        this.gl.glDisable(2881);
        this.smooth = false;
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = BufferUtil.newIntBuffer((int)this.pixels.length);
        }
        this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
        this.pixelBuffer.get(this.pixels);
        this.pixelBuffer.rewind();
        int n = 0;
        int n2 = (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = 0xFF000000 | this.pixels[n2] >> 8 & 0xFFFFFF;
                    this.pixels[n2] = 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = 0xFF000000 | this.pixels[n2] << 16 & 0xFF0000 | this.pixels[n2] & 0xFF00 | this.pixels[n2] >> 16 & 0xFF;
                    this.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= this.width * 2;
        }
    }

    static void nativeToJavaRGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void nativeToJavaARGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void javaToNativeRGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] << 8 & 0xFFFFFF00 | 0xFF;
                    nArray[n4] = n5 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    static void javaToNativeARGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] >> 24 & 0xFF | nArray[n4] << 8 & 0xFFFFFF00;
                    nArray[n4] = n5 >> 24 & 0xFF | n5 << 8 & 0xFFFFFF00;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] & 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = nArray[n4] & 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    public void updatePixels() {
        int n = 0;
        int n2 = (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = this.pixels[n2] << 8 & 0xFFFFFF00 | 0xFF;
                    this.pixels[n2] = n3 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = 0xFF000000 | this.pixels[n2] << 16 & 0xFF0000 | this.pixels[n2] & 0xFF00 | this.pixels[n2] >> 16 & 0xFF;
                    this.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= this.width * 2;
        }
        this.setRasterPos(0.0f, 0.0f);
        this.pixelBuffer.put(this.pixels);
        this.pixelBuffer.rewind();
        this.gl.glDrawPixels(this.width, this.height, 6408, 5121, (Buffer)this.pixelBuffer);
    }

    public int get(int n, int n2) {
        this.gl.glReadPixels(n, n2, 1, 1, 6408, 5121, (Buffer)this.getsetBuffer);
        int n3 = this.getsetBuffer.get(0);
        if (BIG_ENDIAN) {
            return 0xFF000000 | n3 >> 8 & 0xFFFFFF;
        }
        return 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.imageMode == 1) {
            n3 -= n;
            n4 -= n;
        } else if (this.imageMode == 3) {
            n -= n3 / 2;
            n2 -= n4 / 2;
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        PImage pImage = new PImage(n3, n4);
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)(n3 * n4));
        this.gl.glReadPixels(n, n2, n3, n4, 6408, 5121, (Buffer)intBuffer);
        intBuffer.get(pImage.pixels);
        PGraphicsOpenGL.nativeToJavaARGB(pImage);
        return pImage;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int n, int n2, int n3) {
        int n4 = 0;
        n4 = BIG_ENDIAN ? n3 << 8 | 0xFF : n3 & 0xFF00FF00 | n3 << 16 & 0xFF0000 | n3 >> 16 & 0xFF;
        this.getsetBuffer.put(0, n4);
        this.getsetBuffer.rewind();
        this.setRasterPos(n, this.height - n2 - 1);
        this.gl.glDrawPixels(1, 1, 6408, 5121, (Buffer)this.getsetBuffer);
    }

    public void set(int n, int n2, PImage pImage) {
        if (this.imageMode == 3) {
            n -= pImage.width / 2;
            n2 -= pImage.height / 2;
        }
        int[] nArray = new int[pImage.pixels.length];
        System.arraycopy(pImage.pixels, 0, nArray, 0, pImage.pixels.length);
        PGraphicsOpenGL.javaToNativeARGB(pImage);
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)pImage.pixels.length);
        intBuffer.put(pImage.pixels);
        intBuffer.rewind();
        this.setRasterPos(n, this.height - n2 - pImage.height);
        this.gl.glDrawPixels(pImage.width, pImage.height, 6408, 5121, (Buffer)intBuffer);
        pImage.pixels = nArray;
    }

    protected void setRasterPos(float f, float f2) {
        float f3 = 0.0f;
        float f4 = 1.0f;
        this.gl.glPushAttrib(6144);
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDepthRange((double)f3, (double)f3);
        this.gl.glViewport((int)f - 1, (int)f2 - 1, 2, 2);
        float f5 = f - (float)((int)f);
        float f6 = f2 - (float)((int)f2);
        this.gl.glRasterPos4f(f5, f6, 0.0f, f4);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glPopAttrib();
    }

    public void filter(int n) {
        PImage pImage = this.get();
        pImage.filter(n);
        this.set(0, 0, pImage);
    }

    public void filter(int n, float f) {
        PImage pImage = this.get();
        pImage.filter(n, f);
        this.set(0, 0, pImage);
    }

    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.loadPixels();
        super.copy(n, n2, n3, n4, n5, n6, n7, n8);
        this.updatePixels();
    }

    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.loadPixels();
        super.copy(pImage, n, n2, n3, n4, n5, n6, n7, n8);
        this.updatePixels();
    }

    public void blend(int n, int n2, int n3, int n4, int n5) {
        this.set(n3, n4, PImage.blendColor((int)this.get(n, n2), (int)this.get(n3, n4), (int)n5));
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5) {
        this.set(n3, n4, PImage.blendColor((int)pImage.get(n, n2), (int)this.get(n3, n4), (int)n5));
    }

    public void blend(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void blend(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.loadPixels();
        super.blend(pImage, n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.updatePixels();
    }

    public void save(String string) {
        this.loadPixels();
        super.save(string);
    }

    protected final float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public void report(String string) {
        int n;
        if (!this.hints[8] && (n = this.gl.glGetError()) != 0) {
            String string2 = this.glu.gluErrorString(n);
            System.err.println("OpenGL error " + n + " at " + string + ": " + string2);
        }
    }

    protected void add_line(int n, int n2) {
        this.add_line_no_clip(n, n2);
    }

    protected void add_triangle(int n, int n2, int n3) {
        this.add_triangle_no_clip(n, n2, n3);
    }

    public class TessCallback
    extends GLUtessellatorCallbackAdapter {
        public void begin(int n) {
            switch (n) {
                case 6: {
                    PGraphicsOpenGL.this.beginShape(66);
                    break;
                }
                case 5: {
                    PGraphicsOpenGL.this.beginShape(65);
                    break;
                }
                case 4: {
                    PGraphicsOpenGL.this.beginShape(64);
                }
            }
        }

        public void end() {
            PGraphicsOpenGL.this.endShape();
        }

        public void vertex(Object object) {
            double[] dArray;
            if (object instanceof double[]) {
                dArray = (double[])object;
                if (dArray.length != 3) {
                    throw new RuntimeException("TessCallback vertex() data isn't length 3");
                }
            } else {
                throw new RuntimeException("TessCallback vertex() data not understood");
            }
            PGraphicsOpenGL.this.vertex((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }

        public void error(int n) {
            String string = PGraphicsOpenGL.this.glu.gluErrorString(n);
            throw new RuntimeException("Tessellation Error: " + string);
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[dArray.length];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            objectArray2[0] = dArray2;
        }
    }

    protected class ImageCache {
        int tindex = -1;
        int[] tpixels;
        IntBuffer tbuffer;
        public int twidth;
        public int theight;
        int[] tp;

        protected ImageCache() {
        }

        protected void finalize() {
            if (PGraphicsOpenGL.this.deleteQueue.length == PGraphicsOpenGL.this.deleteQueueCount) {
                PGraphicsOpenGL.this.deleteQueue = PApplet.expand((int[])PGraphicsOpenGL.this.deleteQueue);
            }
            if (this.tindex != -1) {
                PGraphicsOpenGL.this.deleteQueue[PGraphicsOpenGL.this.deleteQueueCount++] = this.tindex;
            }
        }

        public void rebind(PImage pImage) {
            block29: {
                int n;
                block28: {
                    if (PGraphicsOpenGL.this.deleteQueueCount != 0) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(PGraphicsOpenGL.this.deleteQueueCount, PGraphicsOpenGL.this.deleteQueue, 0);
                        PGraphicsOpenGL.this.deleteQueueCount = 0;
                    }
                    if (this.tindex != -1) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(1, new int[]{this.tindex}, 0);
                    }
                    int[] nArray = new int[1];
                    PGraphicsOpenGL.this.gl.glGenTextures(1, nArray, 0);
                    this.tindex = nArray[0];
                    int n2 = this.nextPowerOfTwo(pImage.width);
                    int n3 = this.nextPowerOfTwo(pImage.height);
                    if (maxTextureSize == 0) {
                        int[] nArray2 = new int[1];
                        PGraphicsOpenGL.this.gl.glGetIntegerv(3379, nArray2, 0);
                        maxTextureSize = nArray2[0];
                    }
                    if (n2 > maxTextureSize || n3 > maxTextureSize) {
                        throw new RuntimeException("Image width and height cannot be larger than " + maxTextureSize + " with your graphics card.");
                    }
                    if (n2 > this.twidth || n3 > this.theight) {
                        this.tpixels = null;
                    }
                    if (this.tpixels == null) {
                        this.twidth = n2;
                        this.theight = n3;
                        this.tpixels = new int[this.twidth * this.theight];
                        this.tbuffer = BufferUtil.newIntBuffer((int)(this.twidth * this.theight));
                    }
                    n = 0;
                    int n4 = 0;
                    if (!BIG_ENDIAN) break block28;
                    switch (pImage.format) {
                        case 4: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    this.tpixels[n4++] = 0xFFFFFF00 | pImage.pixels[n++];
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break block29;
                        }
                        case 1: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    int n5 = pImage.pixels[n++];
                                    this.tpixels[n4++] = n5 << 8 | 0xFF;
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break block29;
                        }
                        case 2: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    int n6 = pImage.pixels[n++];
                                    this.tpixels[n4++] = n6 << 8 | n6 >> 24 & 0xFF;
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break;
                        }
                    }
                    break block29;
                }
                switch (pImage.format) {
                    case 4: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                this.tpixels[n4++] = pImage.pixels[n++] << 24 | 0xFFFFFF;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                int n7 = pImage.pixels[n++];
                                this.tpixels[n4++] = 0xFF000000 | (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                int n8 = pImage.pixels[n++];
                                this.tpixels[n4++] = (n8 & 0xFF) << 16 | (n8 & 0xFF0000) >> 16 | n8 & 0xFF00FF00;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                }
            }
            this.tbuffer.put(this.tpixels);
            this.tbuffer.rewind();
            PGraphicsOpenGL.this.gl.glBindTexture(3553, this.tindex);
            PGraphicsOpenGL.this.gl.glPixelStorei(3317, 1);
            PGraphicsOpenGL.this.gl.glTexImage2D(3553, 0, 4, this.twidth, this.theight, 0, 6408, 5121, (Buffer)this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9729.0f);
            PGraphicsOpenGL.this.glu.gluBuild2DMipmaps(3553, 4, this.twidth, this.theight, 6408, 5121, (Buffer)this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9987.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10242, 10496.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10243, 10496.0f);
            PGraphicsOpenGL.this.gl.glTexEnvf(8960, 8704, 8448.0f);
        }

        private int nextPowerOfTwo(int n) {
            int n2;
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            return n2;
        }
    }
}

