/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.Logger;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TextOutput
extends Frame {
    public int maxChars = 8192;
    int numChars = 0;
    static TextOutput staticTextOutput;
    static Logger logger;
    boolean isTextAreaEnabled = true;
    boolean isSystemOutEnabled = true;
    TextArea textArea;
    Button buttonClear;
    String lineTerminator = System.getProperty("line.separator", "\n");

    public TextOutput() {
        super("Text Output");
        ((Component)this).setSize(620, 400);
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea("", 30, 120, 0);
        this.textArea.setEditable(false);
        this.textArea.setFont(Font.getFont("Monospaced-18"));
        this.add("Center", this.textArea);
        this.buttonClear = new Button("Clear");
        this.add("South", this.buttonClear);
        this.buttonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextOutput.this.textArea.setText("");
                TextOutput.this.numChars = 0;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextOutput.this.hide();
            }
        });
    }

    public void setTextAreaEnable(boolean bl) {
        this.isTextAreaEnabled = bl;
    }

    public void setSystemOutEnable(boolean bl) {
        this.isSystemOutEnabled = bl;
    }

    private void append(String string) {
        int n = string.length();
        if (this.numChars + n > this.maxChars) {
            int n2 = this.maxChars / 4;
            this.textArea.replaceRange("", 0, n2);
            this.numChars -= n2;
        }
        this.textArea.append(string);
        this.numChars += n;
    }

    public void log(String string) {
        if (this.isSystemOutEnabled) {
            System.out.print(string);
        }
        if (this.isTextAreaEnabled) {
            this.append(string);
        }
    }

    public void logln(String string) {
        this.log(string);
        this.logln();
    }

    public void logln() {
        if (this.isSystemOutEnabled) {
            System.out.println();
        }
        if (this.isTextAreaEnabled) {
            this.append(this.lineTerminator);
        }
    }

    public static void setLogger(Logger logger) {
        TextOutput.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void print(String string) {
        if (staticTextOutput != null) {
            staticTextOutput.log(string);
        } else {
            System.out.print(string);
        }
        if (logger != null) {
            logger.log(string);
        }
    }

    public static void println(String string) {
        if (staticTextOutput != null) {
            staticTextOutput.logln(string);
        } else {
            System.out.println(string);
        }
        if (logger != null) {
            logger.logln(string);
        }
    }

    public static void println() {
        if (staticTextOutput != null) {
            staticTextOutput.logln();
        } else {
            System.out.println();
        }
        if (logger != null) {
            logger.logln();
        }
    }

    public static void error(String string) {
        TextOutput.println("ERROR: " + string);
        throw new RuntimeException(string);
    }

    public static void open() {
        if (staticTextOutput == null) {
            staticTextOutput = new TextOutput();
            ((Component)staticTextOutput).setLocation(30, 0);
        }
        staticTextOutput.show();
    }

    public static void close() {
        if (staticTextOutput != null) {
            staticTextOutput.hide();
        }
    }

    public static void bringToFront() {
        if (staticTextOutput != null) {
            staticTextOutput.toFront();
        }
    }
}

