/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import java.io.OutputStream;
import java.io.PrintWriter;

public class IndentingWriter
extends PrintWriter {
    int spacesPerIndentation = 4;
    int indentation = 0;
    int position = 0;

    public IndentingWriter(OutputStream outputStream) {
        super(outputStream, true);
    }

    public void setIndentation(int n) {
        this.indentation = n;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void indent() {
        ++this.indentation;
    }

    public void undent() {
        --this.indentation;
        if (this.indentation < 0) {
            this.indentation = 0;
        }
    }

    public void print(String string) {
        if (this.position == 0) {
            int n = this.indentation * this.spacesPerIndentation;
            int n2 = 0;
            while (n2 < n) {
                this.print(' ');
                ++n2;
            }
            this.position += n;
        }
        super.print(string);
        this.position += string.length();
    }

    public void println() {
        super.println();
        this.position = 0;
    }

    public void println(String string) {
        this.print(string);
        this.println();
    }
}

