/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthTable;

public class HarmonicTable
extends SynthTable {
    public short[] data;
    double[] partials;
    double[] samples;
    int numPartials;
    int numSamples;
    double minVal = 0.0;
    double maxVal = 0.0;

    public HarmonicTable(int n, int n2) throws SynthException {
        super(n);
        this.partials = new double[n2];
        this.samples = new double[n];
        this.data = new short[n];
        this.numSamples = n;
        this.numPartials = n2;
        this.clear();
    }

    public void setPartial(int n, double d) {
        this.partials[n] = d;
    }

    public double getPartial(int n) {
        return this.partials[n];
    }

    public int getNumPartials() {
        return this.numPartials;
    }

    void addHarmonics() {
        int n = 0;
        while (n < this.numSamples - 1) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.numPartials) {
                double d2 = Math.sin((double)(n2 + 1) * (Math.PI * 2 * (double)n / (double)(this.numSamples - 1)));
                d += this.partials[n2] * d2;
                ++n2;
            }
            this.samples[n] = d;
            ++n;
        }
        this.samples[this.numSamples - 1] = this.samples[0];
    }

    void findMinMax() {
        this.minVal = Double.MAX_VALUE;
        this.maxVal = Double.MIN_VALUE;
        int n = 0;
        while (n < this.numSamples) {
            double d = this.samples[n];
            if (d < this.minVal) {
                this.minVal = d;
            }
            if (d > this.maxVal) {
                this.maxVal = d;
            }
            ++n;
        }
    }

    void scale(double d) {
        int n = 0;
        while (n < this.numSamples) {
            int n2 = n++;
            this.samples[n2] = this.samples[n2] * d;
        }
    }

    void normalize() {
        this.findMinMax();
        double d = Math.max(Math.abs(this.minVal), Math.abs(this.maxVal));
        if (d < 0.001) {
            d = 0.001;
        }
        double d2 = 1.0 / d;
        this.scale(d2);
    }

    public void build() {
        this.addHarmonics();
        this.normalize();
        this.write(this.samples);
        int n = 0;
        while (n < this.numSamples) {
            this.data[n] = (short)(32767.0 * this.samples[n]);
            ++n;
        }
    }

    public void square() {
        int n = 0;
        while (n < this.numPartials) {
            double d = (n & 1) == 1 ? 0.0 : 2.0 / (Math.PI * (double)(n + 1));
            this.partials[n] = d;
            ++n;
        }
        this.build();
    }

    public void triangle() {
        int n = 0;
        while (n < this.numPartials) {
            double d = (n & 1) == 1 ? 0.0 : 1.0 / (double)((n + 1) * (n + 1));
            this.partials[n] = d;
            ++n;
        }
        this.build();
    }

    public void sawtooth() {
        int n = 0;
        while (n < this.numPartials) {
            double d = 1.0 / (double)(n + 1);
            if ((n & 1) == 1) {
                d = -d;
            }
            this.partials[n] = d;
            ++n;
        }
        this.build();
    }

    public void clear() {
        int n = 0;
        while (n < this.numPartials) {
            this.partials[n] = 0.0;
            ++n;
        }
        this.build();
    }
}

