/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.Filter_1o1z;
import com.softsynth.jsyn.InterpolatingDelayUnit;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SampleReader_16V1;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthNote;
import com.softsynth.jsyn.circuits.PluckSample;

public class PluckedString
extends SynthNote {
    SampleReader_16V1 myPluckPlayer = new SampleReader_16V1();
    InterpolatingDelayUnit myDelay;
    Filter_1o1z myAverager;
    MultiplyAddUnit myFeedback;
    public SynthInput rate;
    public SynthInput pluckStrength;
    public SynthInput feedback;
    public SynthInput delay;
    PluckSample myPluckSample;
    static final int PLUCK_SIZE = 300;

    public PluckedString() throws SynthException {
        this(0.01);
    }

    public PluckedString(double d) throws SynthException {
        this.add(this.myPluckPlayer);
        this.myDelay = new InterpolatingDelayUnit(d);
        this.add(this.myDelay);
        this.myAverager = new Filter_1o1z();
        this.add(this.myAverager);
        this.myFeedback = new MultiplyAddUnit();
        this.add(this.myFeedback);
        this.myPluckSample = new PluckSample(300);
        this.myPluckSample.fill();
        this.myDelay.output.connect(this.myAverager.input);
        this.myAverager.output.connect(this.myFeedback.inputA);
        this.myPluckPlayer.output.connect(this.myFeedback.inputC);
        this.myFeedback.output.connect(this.myDelay.input);
        this.rate = this.myPluckPlayer.rate;
        this.addPort(this.rate);
        this.pluckStrength = this.myPluckPlayer.amplitude;
        this.addPort(this.pluckStrength, "PluckStrength");
        this.feedback = this.myFeedback.inputB;
        this.addPort(this.feedback, "Feedback");
        this.delay = this.myDelay.delay;
        this.addPort(this.delay);
        this.output = this.myFeedback.output;
        this.addPort(this.output);
        this.amplitude = this.pluckStrength;
        this.addPort(this.amplitude);
        this.rate.setup(0.0, 20000.0, 60000.0);
        this.pluckStrength.setup(0.0, 0.5, 1.0);
        this.feedback.setup(-1.0, -0.999, -0.9);
        this.delay.setup(0.0, d / 2.0, d);
    }

    public void pluck() throws SynthException {
        this.setStage(this.getSynthContext().getTickCount(), 0);
    }

    public void setStage(int n, int n2) throws SynthException {
        switch (n2) {
            case 0: {
                this.myPluckPlayer.samplePort.queue(n, this.myPluckSample);
                break;
            }
        }
    }
}

