/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.IndentingWriter;
import com.softsynth.util.XMLListener;
import com.softsynth.util.XMLReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class XMLPrinter
extends IndentingWriter
implements XMLListener {
    public XMLPrinter() {
        this(System.out);
    }

    public XMLPrinter(OutputStream outputStream) {
        super(outputStream);
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "xmlpatch.txt";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            XMLReader xMLReader = new XMLReader(fileInputStream);
            xMLReader.setXMLListener(new XMLPrinter());
            xMLReader.parse();
            xMLReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Error = " + iOException);
        }
        catch (SecurityException securityException) {
            System.out.println("Error = " + securityException);
        }
    }

    public void beginElement(String string, Hashtable hashtable, boolean bl) {
        this.print("<" + string);
        this.indent();
        Enumeration enumeration = hashtable.keys();
        if (enumeration.hasMoreElements()) {
            this.println();
        }
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)hashtable.get(string2);
            this.println("\"" + string2 + "\"=\"" + string3 + "\"");
        }
        if (bl) {
            this.undent();
            this.println("/>");
        } else {
            this.println(">");
        }
    }

    public void foundContent(String string) {
        if (string != null) {
            this.println(string);
        }
    }

    public void endElement(String string) {
        this.undent();
        this.println("</" + string + ">");
    }
}

