/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view102;

import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.view102.SynthProbe;
import com.softsynth.jsyn.view102.SynthProbeCircuit;
import com.softsynth.jsyn.view102.SynthScopeProbePanel;
import com.softsynth.jsyn.view102.UsageDisplay;
import com.softsynth.jsyn.view102.WaveDisplay;
import com.softsynth.jsyn.view102.WaveTrace;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class InternalSynthScope
extends Panel
implements Runnable {
    SynthProbeCircuit probeCircuit;
    WaveDisplay waveDisplay;
    Thread autoThread;
    boolean runAuto = false;
    boolean autoEnable;
    double autoRate;
    int sampleSize;
    SynthContext synthContext;
    protected Button captureButton;
    protected Checkbox autoBox;
    protected Button zoomInButton;
    protected Button zoomOutButton;
    protected Button panLeftButton;
    protected Button panRightButton;
    Panel controlPanel;
    Panel buttonPanel;

    public InternalSynthScope(SynthContext synthContext, int n) {
        this.sampleSize = n;
        this.synthContext = synthContext;
        this.setCaptureRate(1.0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.waveDisplay = new WaveDisplay();
        this.add(this.waveDisplay);
        this.waveDisplay.setBackground(Color.black);
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.waveDisplay, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.controlPanel = new Panel();
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.controlPanel, gridBagConstraints);
        this.controlPanel.setLayout(new GridLayout(0, 1));
        this.buttonPanel = new Panel();
        this.controlPanel.add(this.buttonPanel);
        this.captureButton = new Button("Capture");
        this.buttonPanel.add(this.captureButton);
        this.autoBox = new Checkbox("Auto");
        this.buttonPanel.add(this.autoBox);
        this.autoBox.setState(false);
        this.zoomInButton = new Button("Zoom In");
        this.buttonPanel.add(this.zoomInButton);
        this.zoomOutButton = new Button("Zoom Out");
        this.buttonPanel.add(this.zoomOutButton);
        this.panLeftButton = new Button("<<<");
        this.buttonPanel.add(this.panLeftButton);
        this.panRightButton = new Button(">>>");
        this.buttonPanel.add(this.panRightButton);
        this.buttonPanel.add(new UsageDisplay(synthContext));
        this.probeCircuit = new SynthProbeCircuit(synthContext, n);
        this.showControls();
    }

    public void finish(boolean bl) {
        this.probeCircuit.compile();
        this.autoBox.setState(bl);
        this.autoBox.repaint();
        this.handleAutoBox();
    }

    public void finish() {
        this.finish(true);
    }

    public void run() {
        try {
            while (true) {
                if (this.autoEnable) {
                    this.capture();
                }
                Thread.sleep((int)(1000.0 / this.autoRate));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (SynthException synthException) {
            // empty catch block
        }
        this.autoThread = null;
    }

    public void addProbe(SynthScopeProbePanel synthScopeProbePanel) throws SynthException {
        synthScopeProbePanel.useDisplay(this.waveDisplay);
        this.controlPanel.add(synthScopeProbePanel);
        this.repaint();
    }

    public void removeProbe(SynthScopeProbePanel synthScopeProbePanel) throws SynthException {
        synthScopeProbePanel.useDisplay(null);
        this.controlPanel.remove(synthScopeProbePanel);
        this.repaint();
    }

    public SynthScopeProbePanel createProbe(SynthOutput synthOutput, int n, String string, Color color) {
        SynthProbe synthProbe = this.probeCircuit.addProbe(synthOutput, n);
        WaveTrace waveTrace = new WaveTrace(synthProbe.data, color, 1.0);
        SynthScopeProbePanel synthScopeProbePanel = new SynthScopeProbePanel(waveTrace, string);
        this.addProbe(synthScopeProbePanel);
        return synthScopeProbePanel;
    }

    public SynthScopeProbePanel createProbe(SynthOutput synthOutput, String string, Color color) {
        return this.createProbe(synthOutput, 0, string, color);
    }

    public void showControls() {
        this.remove(this.controlPanel);
        this.add(this.controlPanel);
        this.validate();
    }

    public void hideControls() {
        this.remove(this.controlPanel);
        this.validate();
    }

    public void setCaptureRate(double d) {
        if (d > 30.0) {
            d = 30.0;
        }
        this.autoRate = d;
    }

    public double getCaptureRate() {
        return this.autoRate;
    }

    public synchronized void capture() {
        this.probeCircuit.trigger();
        this.synthContext.sleepForTicks(this.sampleSize / this.synthContext.getFramesPerTick() + 1);
        this.probeCircuit.readData();
        this.waveDisplay.repaint();
    }

    protected void handleAutoBox() {
        if (this.autoBox.getState()) {
            this.autoEnable = true;
            if (this.autoThread == null) {
                this.autoThread = new Thread(this);
                this.autoThread.start();
            }
        } else {
            this.autoEnable = false;
        }
    }

    protected boolean handleButtonAction(Component component) {
        if (component == this.captureButton) {
            this.capture();
            return true;
        }
        if (component == this.autoBox) {
            this.handleAutoBox();
            return true;
        }
        if (component == this.zoomInButton) {
            this.waveDisplay.zoomIn();
            this.waveDisplay.repaint();
            return true;
        }
        if (component == this.zoomOutButton) {
            this.waveDisplay.zoomOut();
            this.waveDisplay.repaint();
            return true;
        }
        if (component == this.panLeftButton) {
            this.waveDisplay.panLeft();
            this.waveDisplay.repaint();
            return true;
        }
        if (component == this.panRightButton) {
            this.waveDisplay.panRight();
            this.waveDisplay.repaint();
            return true;
        }
        return false;
    }

    public WaveDisplay getWaveDisplay() {
        return this.waveDisplay;
    }
}

