/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.SynthSound;
import java.util.Vector;

public class SynthCircuit
extends SynthSound {
    public SynthOutput output = null;
    Vector sounds;
    int flags = 0;

    public SynthCircuit(SynthContext synthContext, int n) throws SynthException {
        super(synthContext);
        this.sounds = new Vector(n);
    }

    public SynthCircuit(SynthContext synthContext) throws SynthException {
        this(synthContext, 8);
    }

    public SynthCircuit(int n) throws SynthException {
        this(Synth.getSharedContext(), n);
    }

    public SynthCircuit() throws SynthException {
        this(8);
    }

    public synchronized void add(SynthSound synthSound) throws SynthException {
        if (this.peerToken != 0) {
            throw new SynthException(-200, 0);
        }
        this.sounds.addElement(synthSound);
    }

    public int getPeer() throws SynthException {
        if (this.peerToken == 0) {
            this.compile();
        }
        return super.getPeer();
    }

    public synchronized void compile() throws SynthException {
        if (this.peerToken != 0) {
            return;
        }
        int n = this.sounds.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            SynthSound synthSound = (SynthSound)this.sounds.elementAt(n2);
            nArray[n2] = synthSound.getPeer();
            if (Synth.verbosity >= 2) {
                System.out.println("SynthCircuit.compile: ( " + synthSound.getName() + ", " + Integer.toHexString(synthSound.peerToken));
            }
            ++n2;
        }
        this.peerToken = this.context.createCircuit(nArray, this.flags);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, "Circuit", n);
        }
        if (Synth.verbosity >= 1) {
            System.out.println("SynthCircuit.compiled => " + this);
        }
    }

    public synchronized void delete() throws SynthException {
        int n;
        this.output = null;
        while ((n = this.sounds.size() - 1) >= 0) {
            SynthSound synthSound = (SynthSound)this.sounds.elementAt(n);
            this.sounds.removeElementAt(n);
            synthSound.delete();
        }
        super.delete();
    }

    public static synchronized SynthCircuit loadByName(String string) {
        Class<?> clazz;
        SynthCircuit synthCircuit = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(" Error finding " + string + " = " + classNotFoundException);
            return null;
        }
        try {
            synthCircuit = (SynthCircuit)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println(" Error instantiating " + string + " = " + instantiationException);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(" Error loading " + string + " = " + illegalAccessException);
            return null;
        }
        return synthCircuit;
    }
}

