/*
 * Decompiled with CFR 0.152.
 */
package effects;

import com.xplsv.utils.NumberUtils;
import core.Colour;
import core.Vertex;
import effects.Effect;
import javax.media.opengl.GL;

public class EffectColourFade
extends Effect {
    private Vertex[] meshData;
    private float start_value;
    private float end_value;
    private Colour colour;

    public EffectColourFade(GL gl, int start, int duration, float start_value, float end_value, Colour colour) {
        super(gl, start, duration);
        this.start_value = start_value;
        this.end_value = end_value;
        this.colour = colour;
    }

    public void init() {
        this.meshData = new Vertex[4];
        Vertex v = new Vertex();
        v.position.x = 4.0f;
        v.position.y = 4.0f;
        this.meshData[0] = v;
        v = new Vertex();
        v.position.x = 4.0f;
        v.position.y = -4.0f;
        this.meshData[1] = v;
        v = new Vertex();
        v.position.x = -4.0f;
        v.position.y = -4.0f;
        this.meshData[2] = v;
        v = new Vertex();
        v.position.x = -4.0f;
        v.position.y = 4.0f;
        this.meshData[3] = v;
    }

    public void render() {
        if (!this.active()) {
            return;
        }
        super.render();
        float level = NumberUtils.map(this.position, 0.0f, 1.0f, this.start_value, this.end_value);
        this.gl.glLoadIdentity();
        this.gl.glTranslatef(0.0f, 0.0f, -5.0f);
        this.gl.glBlendFunc(770, 771);
        this.gl.glBegin(7);
        this.gl.glColor4f(this.colour.r, this.colour.g, this.colour.b, level);
        int i = 0;
        while (i < this.meshData.length) {
            this.gl.glVertex3f(this.meshData[i].position.x, this.meshData[i].position.y, this.meshData[i].position.z);
            ++i;
        }
        this.gl.glEnd();
    }
}

