/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Colour;
import core.Vect3D;
import core.Vertex;
import javax.media.opengl.GL;

public class Triangle {
    public Vertex v1;
    public Vertex v2;
    public Vertex v3;
    public Vect3D position;
    public Colour colour;
    public boolean visible;

    public Triangle() {
        this.v1 = new Vertex();
        this.v2 = new Vertex();
        this.v3 = new Vertex();
        this.position = new Vect3D();
        this.visible = true;
    }

    public Triangle(Vertex v1, Vertex v2, Vertex v3) {
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        float positionX = (v1.position.x + v2.position.x + v3.position.x) / 3.0f;
        float positionY = (v1.position.y + v2.position.y + v3.position.y) / 3.0f;
        float positionZ = (v1.position.z + v2.position.z + v3.position.z) / 3.0f;
        this.position = new Vect3D(positionX, positionY, positionZ);
        this.visible = true;
    }

    public void render(GL gl) {
        if (!this.visible) {
            return;
        }
        if (this.colour != null) {
            gl.glColor4f(this.colour.r, this.colour.g, this.colour.b, this.colour.a);
        }
        gl.glBegin(2);
        gl.glVertex3f(this.v1.position.x, this.v1.position.y, this.v1.position.z);
        gl.glVertex3f(this.v2.position.x, this.v2.position.y, this.v2.position.z);
        gl.glVertex3f(this.v3.position.x, this.v3.position.y, this.v3.position.z);
        gl.glEnd();
    }
}

