/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
		
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;

struct VS_INPUT
{
	float3 position  : POSITION;
	float3 normal    : NORMAL;
	float2 texcoord0 : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float4 color0    : COLOR0;
	float2 texcoord0 : TEXCOORD0;
};


VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;
	OUT.color0    = 1.0;
	OUT.texcoord0 = IN.texcoord0;
	OUT.hposition = mul(float4(IN.position.xyz,1.0),bw_ModelViewProjectionMatrix);
	return OUT;
}

/*###############################################
# Pixel Shader
################################################*/

#pragma HLSL_PS

struct VS_OUTPUT
{
	float4 hposition : POSITION;
	float4 color0    : COLOR0;
	float2 texcoord0 : TEXCOORD0;
};

struct PS_OUTPUT
{
	float4 color : COLOR;
};

sampler texture_1:register(s0);
float3 direction;

PS_OUTPUT main( VS_OUTPUT IN )
{
	PS_OUTPUT OUT;
	
	float4 col = float4(0,0,0,0);	
						
	for(float i = -6.0;i<6.0;i+=1.0)
	{
		float off = i*0.0034076;
		float wei = 0.12471*(1.0-(i*i)/36.0);
		col	+=tex2D(texture_1,IN.texcoord0.xy +direction.xy*off )* wei*direction.z;
	}

	OUT.color = col;//col*col*1.4 + col*0.2;	

	return OUT;
}

#end