
from core.gl import *
from core.glu import *
from core import FBO, GLSLShader, Effect, KeyFramer, findFile
import core.scenegraph
from core.scenegraph import Mesh



class CustomRenderer(core.scenegraph.Renderer):
    def __init__(self):
        print "initing"
        try:
            core.scenegraph.Renderer.__init__(self)
        except Exception ,e:
            print "error in custmorenderer", e
             
    
        print "done!"

    def render(self, time, graph):
        """ render graph
        """

        self._meshQueue= []
        self._cameraQueue = []
        self._lightQueue = []





        root = graph.getRootNode()
        self._processNode(time, root, [Mesh])
        
        

#        glMultMatrixf(camMat)
 
#        gluLookAt(0,0,-20,
#                  0,0,0,
#                  0,1,0)

        for job in self._meshQueue:
            glPushMatrix()
            glMultMatrixf(job.getMatrix())
            job.getObject().callList()
            glPopMatrix()        


      



class Ugly3D(Effect):
    def __init__(self, screenDim):
        print "initing effect"
        Effect.__init__(self)

        print "1"
        self._bufferDim = screenDim
        
        print "2"
        self.addParameter("filename", valueType=str)
        self.addParameter("offset", interpolate=True)
        self.addParameter("camera")

        print "3"
        self._renderer = CustomRenderer()

        print "4"
        self._scenes = {}

    def draw(self, time, delta, start, end):
        filename = self._parameters["filename"][time]
        scene = None
        

        try:
            if filename not in self._scenes:
                loader = core.scenegraph.P3SLoader(findFile(filename))
                self._scenes[filename] = loader.load()

        except:
            print "file not found", filename

        try:
            scene = self._scenes[filename]
        except:
            pass

        if not scene:
            return

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(90, 1.333, .1, 150)
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        glEnable(GL_LIGHTING)
        glEnable(GL_LIGHT0)
        glEnable(GL_DEPTH_TEST)

        import math
        fft = self.fft.getSpectralDensity(0, 10)
        t=time+fft*.1
        gluLookAt(math.sin(t), math.cos(t), 1+math.cos(t*.32),
                  0,0,0,
                  0,1,0)


        offset = self._parameters["offset"][time]

        self._renderer.render(offset, scene)

        glDisable(GL_LIGHTING)
        glDisable(GL_DEPTH_TEST)
