/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WEBbrowser
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String initialURL;

    public static void main(String[] args) {
        if (args.length == 0) {
            new WEBbrowser("http://www.cs.unm.edu/");
        } else {
            new WEBbrowser(args[0]);
        }
    }

    public WEBbrowser(String initialURL) {
        super("Simple Browser");
        this.initialURL = initialURL;
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.green);
        JLabel urlLabel = new JLabel("URL:");
        this.urlField = new JTextField(30);
        this.urlField.setText(initialURL);
        this.urlField.addActionListener(this);
        topPanel.add(urlLabel);
        topPanel.add(this.urlField);
        this.getContentPane().add((Component)topPanel, "North");
        try {
            this.htmlPane = new JEditorPane(initialURL);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (IOException ioe) {
            System.out.println("Can't build HTML pane for " + initialURL);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = screenSize.width * 8 / 10;
        int height = screenSize.height * 8 / 10;
        this.setBounds(width / 8, height / 8, width, height);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String url = this.urlField.getText();
        try {
            this.htmlPane.setPage(new URL(url));
            this.urlField.setText(url);
        }
        catch (IOException ioe) {
            System.out.println("Can't follow link to " + url);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
                this.urlField.setText(event.getURL().toExternalForm());
            }
            catch (IOException ioe) {
                System.out.println("Can't follow link to " + event.getURL().toExternalForm());
            }
        }
    }
}

