// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	vpMatrix 				: ViewProjection;
float4 		lightPos				: Light0;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 0.0f, 0.0f, 0.0f };
float		time					: Time;
texture		texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position	: POSITION;
    float2 uvCoords	: TEXCOORD0;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

struct VertexInput_black {
    float3 Position	: POSITION;
};
struct VertexOutput_black {
    float4 Position	: POSITION;
};

struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    float2 uvCoords		: TEXCOORD0;
    half3  lightDir		: TEXCOORD1;
    half3  worldNormal	: TEXCOORD2;
};

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    float3 normal = -float3(IN.Position.x, 0.0f, IN.Position.z);
    IN.Position += float3(IN.Position.x,0.0f,IN.Position.z)*sin(time+IN.Position.y*0.1f)*0.35f;
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    half3 worldNormal = mul(normal, worldMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    OUT.uvCoords = IN.uvCoords.x - time*0.3f;
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	float3 color = tex2D( texture_0Sampler, IN.uvCoords );
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	float diffuseFactor = pow(max(dot( normal, lightDir ),0.0f),2.5f);
	return float4((0.3f + diffuseFactor) * color,1.0f);
}

VertexOutput_black VS_black(VertexInput_black IN) {
    VertexOutput_black OUT;
    IN.Position += float3(IN.Position.x,0.0f,IN.Position.z)*sin(time+IN.Position.y*0.1f)*0.35f;
    OUT.Position = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    return OUT;
}
float4 PS_black( VertexOutput_black IN ) : COLOR
{
	return float4(0.0f,0.0f,0.0f,0.0f);
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}

technique black
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_black();
		PixelShader = compile ps_2_0 PS_black();
    }
}