// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4	worldViewMatrix			: WorldView;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4x4	projMatrix 				: Projection;
float4 		lightPos				: Light0;
float		time : Time;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };

texture texture_0;
sampler2D texture_0Sampler = sampler_state 
{
    texture = <texture_0>;
    AddressU  = WRAP;        
    AddressV  = WRAP;
    AddressW  = WRAP;
    MIPFILTER = LINEAR;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

struct VertexInput {
    float3 Position		: POSITION;
    float2 uvCoords 	: TEXCOORD0;
    float3 Expansion 	: TEXCOORD1;
    float3 color		: TEXCOORD2;
};

struct VertexOutput
{
    float4 HPosition	: POSITION;
	float2 uvCoords		: TEXCOORD0;
	float4 color		: TEXCOORD1;
};


VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    float4 worldPos = mul(float4(IN.Position,1.0f), worldViewMatrix);
    worldPos += float4(IN.Expansion,0.0f);
    OUT.HPosition = mul(worldPos, projMatrix);
    OUT.uvCoords = IN.uvCoords;
    OUT.color = float4(IN.color.rgb, 0.8f);
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : COLOR
{
	return IN.color.rgba*tex2D(texture_0Sampler,IN.uvCoords).rgba;
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse();
		PixelShader = compile ps_2_0 PS_Diffuse();
		AlphaBlendEnable = true;
		srcBlend = srcAlpha;
		destBlend = invSrcAlpha;
		ZEnable = true;
		ZWriteEnable = false;
    }
}