// Per-Pixel diffuse lighting

float4x4	worldMatrix				: World;
float4x4 	worldViewProjMatrix 	: WorldViewProjection;
float4 		lightPos				: Light0;
float3		diffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		ambientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };

struct VertexInput {
    float3 Position	: POSITION;
    float3 Normal	: NORMAL;
};

struct VertexOutput {
    float4 position	: POSITION;
    float3 color	: COLOR;
};

struct VertexOutput_ps20
{
    float4 HPosition	: POSITION;
    half3 lightDir		: TEXCOORD0;
    half3 worldNormal	: TEXCOORD1;
};

VertexOutput VS_Diffuse_fixed(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    half3 worldNormal = mul(IN.Normal, worldMatrix);
    worldNormal = normalize(worldNormal);
    float3 lightDir = normalize(lightPos - worldPos);
    OUT.position = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
	OUT.color = max(0,dot( worldNormal, lightDir )) * diffuseColor + ambientColor;
    return OUT;
}

VertexOutput_ps20 VS_Diffuse_ps20(VertexInput IN) {
    VertexOutput_ps20 OUT;
    
    float3 worldPos = mul(float4(IN.Position,1.0f), worldMatrix);
    half3 worldNormal = mul(IN.Normal, worldMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.HPosition = mul(float4(IN.Position,1.0f), worldViewProjMatrix);
    return OUT;
}

float4 PS_Diffuse( VertexOutput_ps20 IN ) : COLOR
{
	half3 normal =  normalize(IN.worldNormal);
	half3 lightDir = normalize(IN.lightDir);
	return float4(max(0,dot( normal, lightDir )) * diffuseColor + ambientColor,1.0f);
}

technique fixed
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_fixed();
		PixelShader = NULL;
		
		ColorVertex = true;
    }
}

technique ps20
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS_Diffuse_ps20();
		PixelShader = compile ps_2_0 PS_Diffuse();
    }
}