import derelict.sdl.sdl;
import derelict.sdl.mixer;
import derelict.sdl.image;

SDL_Event event;
bool run = true;

void ApplySurface(int x, int y, SDL_Surface* source, SDL_Surface* dest)
{
    SDL_Rect offset;
    offset.x = x;
    offset.y = y;
    SDL_BlitSurface(source, null, dest, &offset);
}

SDL_Surface* LoadImage(char* filename)
{
    SDL_Surface* img = IMG_Load(filename);
    SDL_Surface* convimg = null;
    if(img != null)
    {
        convimg = SDL_DisplayFormat(img);
        SDL_FreeSurface(img); //Fria minnet.
    }
    return convimg; //Returna den processerade bilden.
}

class Display
{
	private
	{
		SDL_Surface* Screen;
		int w,h,bpp;
	}
	public
	{
		this(int x, int y, int c)
		{
			DerelictSDL.load();
			DerelictSDLImage.load();
			DerelictSDLMixer.load();
			
			w = x;
			h = y;
			bpp = c;
			
			
			
			if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER | SDL_INIT_AUDIO) < 0)
			{
				throw new Error("Couldn't initialize SDL.");
			}
			
			if((Screen = SDL_SetVideoMode(w, h, bpp,
			 SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_FULLSCREEN)) == null)
			{
				throw new Error("Couldn't set video mode.");
			}
			
			SDL_WM_SetCaption("Rallylax!", null);
		}
		
		SDL_Surface* GetScreen()
		{
			return Screen;
		}
		
		int GetW()
		{
			return w;
		}
		
		void Quit()
		{
			run = false;
		}
		
		void Clear()
		{
			SDL_Rect offset;
			
			offset.x = 0;
			offset.y = 0;
			offset.w = w;
			offset.h = h;
			
			Uint32 color = SDL_MapRGB(Screen.format,144,183,67);
			SDL_FillRect(Screen, &offset, color);
		}
	}
}

class Fisk
{
	private
	{
		int x,y,w,s;
		SDL_Surface* gfx;
	}
	
	public
	{
		this(int ix, int iy, char* gfxpath, int iw)
		{
			x = ix;
			y = iy;
			w = iw;
			gfx = LoadImage(gfxpath);
			s = 5;
		}
	
		void ChangePos(int nx, int ny)
		{
			x = nx;
			y = ny;
		}
		
		int GetX()
		{
			return x;
		}
		
		int GetY()
		{
			return y;
		}
		
		void SetSpeed(int _s)
		{
			s = _s;
		}
	
		void Move(bool right, int sw)
		{
			if(right)
			{
				x += s;
				if(x > sw)
					x = 0-w;
			}
			else
			{
				x -= s;
				if(x+w < 0)
					x = sw+1;
			}
		}
		
		SDL_Surface* GetGfx()
		{
			return gfx;
		}
	}
}

int main()
{
	
	int audio_rate = 22050;
	Uint16 audio_format = AUDIO_S16SYS;
	int audio_channels = 2;
	int audio_buffers = 4096;
	
	DerelictSDLImage.load();
	DerelictSDLMixer.load();
	
	Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers);
	Display MainDisplay = new Display(1280,720,32);
	Fisk Lax = new Fisk(0,10,"laxen.png",1280);
	Fisk Laxrally = new Fisk(0,600,"text.png",408);
	Fisk CPBOG = new Fisk(0,0,"katten.png",1280);
	
	
	Mix_Music* music = Mix_LoadMUS("musik.ogg");
	Mix_PlayMusic(music, 0);
	int firstframe = SDL_GetTicks();
	
	while((SDL_GetTicks() - firstframe) < 23150 && run)
	{
		while (SDL_PollEvent(&event))
		{
            switch (event.type)
			{
                case SDL_QUIT:
					MainDisplay.Quit();
                default:
                    break;
            }
			switch (event.key.keysym.sym)
			{
				case SDLK_ESCAPE:
					MainDisplay.Quit();
					break;
				default:
					break;
			}
        }


		if((SDL_GetTicks() - firstframe) > 17800)
		{
			Lax.SetSpeed(15);
			Laxrally.SetSpeed(10);
		}
		
		if((SDL_GetTicks() - firstframe) > 21300)
		{
			Lax.SetSpeed(30);
			Laxrally.SetSpeed(20);
		}
		
		MainDisplay.Clear();
		Lax.Move(true,MainDisplay.GetW());
		Laxrally.Move(false,MainDisplay.GetW());
		ApplySurface(Lax.GetX(),Lax.GetY(),Lax.GetGfx(),MainDisplay.GetScreen());
		ApplySurface(Laxrally.GetX(),Laxrally.GetY(),Laxrally.GetGfx(),MainDisplay.GetScreen());
		
		SDL_Flip(MainDisplay.GetScreen());
		
		SDL_Delay(5);
	}
	
	
	MainDisplay.Clear();
	ApplySurface(CPBOG.GetX(),CPBOG.GetY(),CPBOG.GetGfx(),MainDisplay.GetScreen());
	SDL_Flip(MainDisplay.GetScreen());
	SDL_Delay(4000);
	
	return 0;
}