<?php
//ini_set('display_errors', '1');
require_once('settings.php');
require_once(dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'settings.php');
require_once('DB.php');
require_once('SessionManager.php');
require_once('ProtocolViolationException.php');

header('Content-Type: text/plain');

try {
    $settings = getSettings();

//error_log(print_r($_POST, true));
    if (!isset($_POST['RT'])) {
        throw new ProtocolViolationException('RT field missing');
    }
    $requestType = $_POST['RT'];
    $requestMessage = isset($_POST['RM']) ? $_POST['RM'] : '';
    $clientId = isset($_POST["C"]) ? $_POST["C"] : '';

    $db = new DB($settings['db_dsn']);

    $manager = new SessionManager($db);
    $sessionId = null;

    if (!$clientId) {
        // New client?
        if ($requestType != "NEWUSER")
            throw new ProtocolViolationException('Player not registered');

        if (!preg_match('/[a-zA-Z0-9-_ ]/', $requestMessage) || strlen($requestMessage) > 20 || strlen($requestMessage) < 1)
            throw new ProtocolViolationException("Invalid user name '$requestMessage'");
        $clientId = $manager->createClient($requestMessage);
        echo $clientId;
        return;
    }

    $manager->updateLastCommunicationTime($clientId);

    if (!in_array($requestType, array('DEBUGLOG'))) {
        if (!$manager->clientExists($clientId))
            throw new ProtocolViolationException("Client $clientId not known");
    }
    $sessionId = $manager->getClientSession($clientId);

    $manager->dropLaggers();

    switch ($requestType) {
        case "NEWSESS":
            $requestMessage = explode("\n", $requestMessage);
            if (count($requestMessage) < 2)
                throw new ProtocolViolationException("Request too short");
            $sessionName = array_shift($requestMessage);
            $maxClients = array_shift($requestMessage);
            $sessionMetadata = implode("\n", $requestMessage);

            if (!ctype_alnum($sessionName) || strlen($sessionName) > 20)
                throw new ProtocolViolationException("Invalid session name");
            if (!ctype_alnum($maxClients) || $maxClients > 8)
                throw new ProtocolViolationException("Erranous maximum clients value");
            list($sessionId, $masterKey) = $manager->createSession($sessionName, $clientId, $maxClients, $sessionMetadata);
            echo "$sessionId|$masterKey";
            break;
        case "LISTSESS":
            echo json_encode($manager->getJoinableSessions());
            break;
        case "SESSPROP":
            if (!$requestMessage) {
                if (!$sessionId)
                    throw new ProtocolViolationException("This client has not yet joined a session.");
                $sess = $sessionId;
            } else {
                $sess = $requestMessage;
            }
            $data = $manager->getSessionProperties($sessionId);
            $data['id'] = $sessionId;
            echo json_encode($data);
            break;
        case "NEWUSER":
            assert('false'); // Should be handled above
            break;
        case "JOINSESS":
            $manager->joinSession($requestMessage, $clientId);
            break;
        case "CHATPOST":
            if (!$sessionId)
                throw new ProtocolViolationException("This client has not yet joined a session.");
            $manager->addChatMessage($sessionId, $clientId, $requestMessage);
            break;
        case "PREGAMEREFRESH":
            if (!$sessionId)
                throw new ProtocolViolationException("This client has not yet joined a session.");

            // See if the game has started
            if ($manager->hasGameStarted($sessionId)) {
                echo "START";
                break;
            }

            $minId = $requestMessage;
            $messages = $manager->getChatMessages($sessionId, $minId);
            foreach ($messages as $message) {
                echo $message['id'] . '|' . $message['sender'] . '|' . $message['msg'] . "\n";
            }
            break;
        case "STARTGAME":
            $masterKey = $requestMessage;
            if (!$manager->isMasterClient($clientId, $masterKey))
                throw new ProtocolViolationException("Not the master client.");
            $manager->startGame($sessionId);
            break;
        case "STEP":

            if (!$sessionId || !$clientId)
                throw new ProtocolViolationException("Not in a session.");

            /*
             * The request is divided into three lines.
             *
             * The first line must contain the serial number of
             * the command up to which all commands have been received.
             *
             * The second line must contain the current ping estimate by
             * the client.
             *
             * The last line is a sequence of commands separated by pipes (|).
             * Each command is formatted as follows:
             * <serial>&<time>&<object-id>&<command-name>&<flags>
             *
             * The <serial> and <time> fields are not sent by the clients.
             * They are tacked on by the server.
             *
             * Response:
             * <end of time>:<commands after the given serial>
             */
            $requestMessage = explode("\n", $requestMessage);
            if (count($requestMessage) < 2 || count($requestMessage) > 3) {
                throw new ProtocolViolationException("Invalid request", $clientId);
            }
            $lastCommandSynced = $requestMessage[0];
            $ping = $requestMessage[1];
            if (isset($requestMessage[2]))
                $commands = $requestMessage[2];
            else
                $commands = array();

            if (!ctype_digit(strval($lastCommandSynced)))
                throw new ProtocolViolationException("Invalid command serial.");
            if (!ctype_digit(strval($ping)))
                throw new ProtocolViolationException("Invalid ping value.");

            $manager->storePing($clientId, $ping);

            $manager->updateLastCommandSynced($sessionId, $clientId, $lastCommandSynced);

            $commands = explode('|', $commands);
            foreach ($commands as $command) {
                if (!empty($command)) {
//error_log("GOT COMMAND $command");
                    $parts = explode('&', $command);
                    if (count($parts) !== 3) {
                        throw new ProtocolViolationException("Invalid command '$command'", $clientId);
                    }

                    // added by droppen, advance to new time
                    // pick up any comamnd with that name
                    if ($parts[1] == "advancelockstep") {
                        // the object id will now be the master key
                        $masterKey = $parts[0];
                        $newTimeLimit = (int)$parts[2];

                        if (!$manager->isMasterClient($clientId, $masterKey)) {
                            throw new ProtocolViolationException("Not the master client");
                        }


                        $manager->setEndOfTimeLimit($sessionId, $newTimeLimit);
                    } else {
                        $manager->enqueueCommand($sessionId, $clientId, $command);
                    }
                }
            }

            $newCommands = $manager->getNewCommands($sessionId, $lastCommandSynced + 1);

            echo $manager->getEndOfTime($sessionId);
            echo ':';
            $newCommandsFormated = array();
            foreach ($newCommands as $commandSerial => $newCommand) {
                list($commandTime, $commandMessage) = $newCommand;
                $newCommandsFormated[] = "$commandSerial&$commandTime&$commandMessage";
            }
            echo implode('|', $newCommandsFormated);
//error_log("Responding with " . $manager->getEndOfTime($sessionId) . ':' . implode('|', $newCommandsFormated));
            break;
        case 'LOGCHECKSUM':
            $requestMessage = explode('|', $requestMessage);
            if (count($requestMessage) !== 2)
                throw new ProtocolViolationException('Invalid LOGCHECKSUM request');
            list($gameTime, $checksum) = $requestMessage;
            $manager->logChecksum($sessionId, $clientId, $gameTime, $checksum);

            // fall through (no break)
        case 'VERIFYCHECKSUM':
            $mismatchTime = $manager->verifyChecksums($sessionId, $clientId);
            if ($mismatchTime === null)
                echo 'OK';
            else
                echo $mismatchTime;
            break;
        case 'DEBUGLOG':
            if (isDebugLogEnabled()) {
                $lineSeparator = "\n***+++***\n";
                $lines = explode($lineSeparator, $requestMessage);
                foreach ($lines as $line) {
                    $line = explode('|', $line);
                    if (count($line) >= 2) {
                        $gameTime = array_shift($line);
                        $msg = implode('|', $line);
                        $manager->debugLog($clientId, $gameTime, $msg);
                    }
                }
            }
            break;
        default:
            throw new ProtocolViolationException($requestType." not a valid request type", $clientId);
            break;
    }
}
catch (Exception $e) {
    error_log($e);
    header('Content-Type: text/plain', true, 500);
    echo $e->getMessage();
}
