<?php
require_once('./settings.php');
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title>Webdune lobby</title>

<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/json2.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/urlencode.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/siteSettings.js.php"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/settings.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/ajax.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/lobby.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/engine/utils.js"></script>
<script type="text/javascript" src="<?php echo getBaseUrl(); ?>/lib/cookie.js"></script>

<script type="text/javascript">
<!--
var lobby = new Lobby();


function createSession() {
    var createBtn = document.getElementById('createButton');
    var sessionNameInput = document.getElementById('newSessionName');
    var sessionName = sessionNameInput.value;

    if (sessionName.length > 0) {

        function failure(data) {
            alert('Failed to create game: ' + data);
        }

        function success(data) {
            data = data.split('|');
            if (!data[0] || !data[1]) {
                alert('Weird response from server.');
                return;
            }

            var sessionId = data[0];
            var masterKey = data[1];

            var requestData = {
                'C': lobby.clientId,
                'RT': 'JOINSESS',
                'RM': sessionId + "\n"
            }

            function gotoPregame() {
                window.location.href = '<?php echo getBaseUrl(); ?>/pregame.php?clientId=' + lobby.clientId +
                                   '&masterKey=' + masterKey;
            }

            new Ajax('<?php echo getBaseUrl(); ?>/server/gameserver.php', gotoPregame, 'POST', requestData, failure);
        }

        var sessionMetadata = {
            'map': 'new_map'
        }

        var requestData = {
            'C': lobby.clientId,
            'RT': 'NEWSESS',
            'RM': sessionName + "\n" +
                  '2' + "\n" + // Hard coded maximum players for now
                  JSON.stringify(sessionMetadata)
        }

        new Ajax('<?php echo getBaseUrl(); ?>/server/gameserver.php', success, 'POST', requestData, failure);
    }
}

function joinSession(sessionId) {
    var ajax = new Ajax();

    function success(data) {
        window.location.href =
            '<?php echo getBaseUrl(); ?>/pregame.php?clientId=' + lobby.clientId;
    }

    function failure(data) {
        alert('Failed to join game: ' + data);
    }

    var requestData = {
        'C': lobby.clientId,
        'RT': 'JOINSESS',
        'RM': sessionId
    };

    new Ajax('<?php echo getBaseUrl(); ?>/server/gameserver.php', success, 'POST', requestData, failure);
}


function updateSessionList() {
    var tblContainer = document.getElementById('sessionTableContainer');
    var tbl = document.createElement('table');
    while (tblContainer.firstChild)
        tblContainer.removeChild(tblContainer.firstChild);

    for (i = 0; i < lobby.joinableGames.length; ++i) {
        var game = lobby.joinableGames[i];

        var row = tbl.insertRow(-1);
        var nameCol = row.insertCell(0);
        var linkCol = row.insertCell(1);
        nameCol.appendChild(document.createTextNode(game.name));

        var link = document.createElement('a');
        link.appendChild(document.createTextNode('join'));
        link.href = '#';
        (function() { // New closure to contain the game ID
            var gameId = game.id;
            link.onclick = function() { joinSession(gameId); };
        })();
        linkCol.appendChild(link);
    }

    tblContainer.appendChild(tbl);
}

function promptName()
{
    lobby.setName(prompt("Player name?", "Anonymous Coward"), setupLobbyUI)
}

function setupLobbyUI() {
    createCookie("clientId",lobby.clientId,1);

    function refreshLobbyEventHandler() {
        lobby.refresh(updateSessionList);
        return false;
    }

    document.getElementById('refreshButton').onclick = refreshLobbyEventHandler;
    document.getElementById('createButton').onclick = function() { createSession(); return false; }
    document.getElementById('changeName').onclick = function() { promptName(); return false; }

    setInterval(refreshLobbyEventHandler, 5000);
}

if (!lobby.clientId || lobby.clientId == null || lobby.clientId == false || lobby.clientId == "null")
{
    promptName();
}
else
{
    window.onload = chainCalls(window.onload, setupLobbyUI);
}
// -->
</script>

</head>
<body bgcolor="#aaaaaa">
<center>
<!-- img src="data/banner.gif" alt="" / -->

<h2>Open games</h2>
<div id="sessionTableContainer">
</div>
<br />

<button id="refreshButton">Refresh</button>
<button id="changeName">Change name</button>

<div>
    <h2>Create game</h2>
    <input id="newSessionName" type="text" maxlength="128" value="" />
    <br />
    <button id="createButton">Create</button>
</div>
<br>If you dont see any games, host one. (dont worry, you dont need to install anything)
<br>
<br>
<b>Wellcome to webdune!</b>
<br>
<br>Webdude has been successfully rewritten!
<br>and Opera 9+ and firefox 3 are the supported browzers now.
<br>Webdune is a browzer based MULTIPLAYER RTS game, that should be clear by now
<br>it supports up to 4 players right now.
<br>
<br>Webdune was coded in and is hosted by Cafe Level 7 in Helsinki,
<br>I've been coding it during work shifts for the past 3 months, with lagitus.
<br><b>For bug reports, comments, questions, visit the forums at
<a href="http://www.cafelevel7.fi/index.php?s=foorumi&cat=7&top=135">THIS LINK</a></b>
<br>
<br>Made by Konsta "Droppen" Gogoljuk and Martin "lagitus" P&auml;rtel
</center>
</body>
</html>