function TopLayer()
{
    var self= this;
    this.gameMessage = document.createElement('gameMessage');
    this.objectName = document.createElement('objectName');
    this.constInfo = document.createElement('constructionInformation');
    
    this.button1 = document.createElement('button1');
    this.button2 = document.createElement('button2');
    this.button3 = document.createElement('button3');
    this.button4 = document.createElement('button4');
    
    this.init = function()
    {
        this.createDiv(this.gameMessage,[10,21],[290,14],10,"#444444");
        this.createDiv(this.objectName,[260,42],[100,5],7,"black");
        this.createDiv(this.constInfo,[295,91],[20,24],5,"black");
        
        
        this.createDiv(this.button1,[260,78],[11,60],7,"black");
        this.createDiv(this.button2,[260,89],[11,60],7,"black");
        this.createDiv(this.button3,[260,100],[11,60],7,"black");
        this.createDiv(this.button4,[260,111],[11,60],7,"black");
    }
    this.createDiv = function(element, pos, size, fontSize, color)
    {
        var rel = (settings.canvasSize[0]/settings.gameResolution[0]);
        element.style.position = "absolute";
        element.style.left = ((settings.canvasPos[0]/rel)+pos[0])*rel;
        element.style.top = ((settings.canvasPos[1]/rel)+pos[1])*rel;
        element.style.width = size[0]*rel;
        element.style.height = size[1]*rel;
        element.style.fontFamily = "Impact";
        element.style.fontSize = fontSize*rel;
        element.style.color = color;
        element.innerHTML = "";
        element.style.textAlign = "left";
        document.body.appendChild(element);
    }
    this.setObjectName = function(text)
    {
        this.objectName.innerHTML = text;
    }
    this.setGameMessage = function(text)
    {
        this.gameMessage.innerHTML = text;
        //setTimeout(function () {self.setGameMessage(""); }, 3000);
    }
    this.setConstInfo = function(text)
    {
        this.constInfo.innerHTML = text;
    }
    this.setButtonText = function(no,text)
    {
        switch (parseInt(no))
        {
        case 0:
                this.button1.innerHTML = text;
            break;
        case 1:
                this.button2.innerHTML = text;
            break;
        case 2:
                this.button3.innerHTML = text;
            break;
        case 3:
                this.button4.innerHTML = text;
            break;
        }
    }
    this.clearButtons = function()
    {
        this.button1.innerHTML = "";
        this.button2.innerHTML = "";
        this.button3.innerHTML = "";
        this.button4.innerHTML = "";
    }
    this.init();
}