
/*
 * Session:
 * - id: the session identifier.
 * - clientId: the ID of the client we represent.
 * - name: the name of the session.
 * - joinable: whether the session is still joinable.
 * - masterClient: the ID of the master client.
 * - clients: an array of {'id': ..., 'name': ..., 'playerNum': ..., 'timeSinceLastUpdate': ...} client records.
 * - ready: whether the session has been refreshed at least once.
 * - refresh(): refreshes the session's properties and calls a callback.
 * 
 * All fields except for id, clientId and the functions are initially set to null.
 */
function Session(clientId) {
    this.id = null;
    this.clientId = clientId;
    this.name = null;
    this.joinable = null;
    this.masterClient = null;
    this.clients = null;
    this.playerId = null;
    this.map = null;
    this.ready = false; // whether the session has been refreshed at least once
    
    var self = this;
    
    this.refresh = function(callback, errorCallback /* = null */) {
        
        function success(data) {
            data = JSON.parse(data);

            metadata = JSON.parse(data.metadata);

            self.id = data.id;
            self.name = data.name;
            self.joinable = data.joinable;
            self.masterClient = data.masterClient;
            self.map = metadata.map;
            self.clients = data.clients;
            self.playerId = data.clients[self.clientId].playerNum;
            self.ready = true;

            if (typeof(callback) == 'function')
                callback(self);
        }
        
        var request = {
            'C': this.clientId,
            'RT': 'SESSPROP'
        };
        new Ajax(settings.serverUrl, success, 'POST', request, errorCallback);
    }

    this.parsePlayerPings = function(serializedPings)
    {
        if (serializedPings)
            self.clients = JSON.parse(serializedPings);
    }
}
