
/*
 * Ping measurement component.
 */
function Ping()
{
    /*
     * We store up to this._pingMeasureWindowSize round trip times in
     * this._pingMeasurements.
     * getPing() calculates the average to this._pingAvg.
     */
	this._pingMeasureWindowSize = 20;
	this._pingMeasurements = []; // Acts as a queue (unshift to add, pop to remove)
	this._pingAvg;
	this._pingAvgUpToDate = false;
	
	this.getPing = function()
	{
		if (!this._pingAvgUpToDate) {
			this._pingAvg = 0;
			if (this._pingMeasurements.length > 0) {
				for (var i in this._pingMeasurements)
					this._pingAvg += this._pingMeasurements[i];
				this._pingAvg /= this._pingMeasurements.length;
			}
			this._pingAvgUpToDate = true;
		}
		return this._pingAvg;
	}
	
	this.addPingMeasurement = function(ping)
	{
		this._pingAvgUpToDate = false;
		this._pingMeasurements.unshift(ping);
		while (this._pingMeasurements.length > this._pingMeasureWindowSize)
			this._pingMeasurements.pop();
	}
}
