
/*
 * ObjectDescriptor - stores the properties of a type of object.
 */
function ObjectDescriptor(name) {
    //default values
    this.desc = name;
    this.name = name;
    this.fullname = this.name;
    this.pic = "pic/pic"+name+".png";
    this.img = "units/"+name+".png";
    this.imgtype = "static";
    this.isUnit = false;
    this.maxhp = 100;
    this.attackRange = 1;
    this.size = [1,1];
    this.cost = 100;
    this.isFlat = false;
    this.canbuild = false;
    this.attackDamage = 5;
    this.sight = 1;
    this.fireRate = 5;
    
    //action times
    this.actionTimeLength = Array();
    this.actionTimeLength["move"] = 1000;
    this.actionTimeLength["turn"] = 200;
    this.actionTimeLength["harvest"] = 5000;
    this.actionTimeLength["unloadspice"] = 5000; // how much time you spend on the refinery
    this.actionTimeLength["shoot"] = 1000;
    this.actionTimeLength["explode"] = 3000;
    this.actionTimeLength["construct"] = 2000;
    this.actionTimeLength["wait"] = 2000;
    
    //object specific
    switch (name)
    {
        case "quad":
            this.name = "Quad";
            this.imgtype = "long8";
            this.isUnit = true;
            this.commands = ["attack","move","stop"];
            this.attackRange = 2;
            this.attackDamage = 10;
            this.maxhp = 100;
            this.size = [1,1];
            this.cost = 800;
            this.actionTimeLength["construct"] = 60000;
        break;
        case "infantry":
            this.name = "Infantry";
            this.imgtype = "troop";
            this.isUnit = true;
            this.commands = ["attack","move","stop"];
            this.attackRange = 2;
            this.attackDamage = 5;
            this.maxhp = 80;
            this.size = [1,1];
            this.cost = 400;
            this.actionTimeLength["construct"] = 30000;
        break;
        case "bazooka":
            this.name = "Bazooka";
            this.imgtype = "troop";
            this.isUnit = true;
            this.commands = ["attack","move","stop"];
            this.attackRange = 3;
            this.attackDamage = 20;
            this.maxhp = 80;
            this.size = [1,1];
            this.cost = 1000;
            this.actionTimeLength["construct"] = 30000;
            this.actionTimeLength["shoot"] = 3000;
            this.fireRate = 2;
        break;
        case "silo":
            this.name = "Silo";
            this.imgtype = "static";
            this.img = "buildings/silo.png";
            this.isUnit = false;
            this.maxhp = 100;
            this.size = [1,1];
            this.cost = 500;
            this.canbuild = false;
            this.actionTimeLength["construct"] = 8000;
        break;
        case "radar":
            this.name = "Radar";
            this.imgtype = "static";
            this.img = "buildings/radar.png";
            this.isUnit = false;
            this.maxhp = 100;
            this.size = [2,2];
            this.cost = 1000;
            this.canbuild = false;
            this.actionTimeLength["construct"] = 20000;
        break;
        case "harvester":
            this.name = "Harvester";
            this.img = "units/harvester.png";
            this.imgtype = "long8";
            this.isUnit = true;
            this.commands = ["harvest","move","stop"];
            this.maxhp = 100;
            this.size = [1,1];
            this.storage = 1000; // how much spice can a harvester hold?
            this.spice = 2000;
            this.cost = 200;
        break;
        case "mcv":
            this.name = "MCV";
            this.img = "units/mcv.png";
            this.imgtype = "long8";
            this.isUnit = true;
            this.commands = ["deploy","move","stop"];
            this.maxhp = 150;
            this.size = [1,1];
            this.cost = 3000;
        break;
        case "constructionyard":
            this.name = "Const Yrd";
            this.fullname = "Construction Yard";
            this.img = "buildings/constructionyard.png";
            this.imgtype = "static";
            this.isUnit = false;
            this.maxhp = 500;
            this.size = [2,2];
            this.canbuild = true;
            this.builds = ["constructionyard","slab","refinery","barracks","radar","silo"];
            this.cost = 1000;
        break;
        case "barracks":
            this.name = "Barracks";
            this.img = "buildings/barracks.png";
            this.imgtype = "static";
            this.isUnit = false;
            this.maxhp = 300;
            this.size = [2,2];
            this.canbuild = true;
            this.builds = ["infantry","mcv","quad","bazooka"];
            this.cost = 500;
        break;
        case "refinery":
            this.name = "Refinery";
            this.img = "buildings/refinery.png";
            this.imgtype = "static";
            this.isUnit = false;
            this.maxhp = 400;
            this.size = [3,2];
            this.builds = ["harvester"];
            this.canbuild = true;
            this.cost = 500;
        break;
        case "slab":
            this.name = "Slab";
            this.img = "buildings/slab.png";
            this.imgtype = "static";
            this.isUnit = false;
            this.maxhp = 10;
            this.size = [1,1];
            this.canbuild = false;
            this.cost = 10;
            this.isFlat = true;
        break;
    }
    for (var a in this.actionTimeLength)
        this.actionTimeLength[a] = Math.round(this.actionTimeLength[a]/settings.gameSpeed);
}

