// mouse handler needs draw!!

/*
    This is the Mouse Handler, it binds all mouse events, and passes them on after some conversion
    it allso does some actual mouse effect. (not sure if i should move it somewhere else)
    Mouse handler uses alot of the draw class.
    
    mouseHandler - main function that parses and moves forward all commands
    minimapHandler - handles all mouse commands directed to minimap.
    convertToGameCoords - Converts mouse coords to game resolution.
*/


function Mouse()
{
    var self = this;
    this.game = game;
    
    // here we store the game mouse pos in real game coords.
    this.gameMousePos = Array();
    
    // for dragging, see below for more comments
    // 1 if minimap, 2 if unit select dragging
    this.IsButtonDown /* = int */;
    
    // for selecting multiple units
    this.mouseDragStart = Array();

    document.onmousedown = function (evt)
    {
        self.mouseHandler([evt.pageX,evt.pageY],"down");
    }

    document.onmousemove = function (evt)
    {
        self.mouseHandler([evt.pageX,evt.pageY],"move");
    }

    document.onmouseup = function (evt)
    {
        self.mouseHandler([evt.pageX,evt.pageY],"up");
    }
    


    this.mouseHandler = function (crd/*mouse coords, an array, [0]=x [1]=y*/, mode/*down,move,up*/)
    {
        crd = this.convertToGameCoords(crd);
        // the coords were not valid game coords, return.
        if (!crd)
            return
        
        if (mode == "down")
        {
            // if its for the minimap
            if (within(crd,settings.minimapPos, [settings.minimapSize,settings.minimapSize]))
            {
                map.minimap.mouseHandler(crd);
                this.IsButtonDown = 1;
            }
                
            // get the ui poisitions from draw, now we know if the click is in the game
            // we can count witch cell was clicked with this pattern:
            if (within(crd,settings.visualMapPosition,settings.visualMapSize))
            {
                this.IsButtonDown = 2;
                this.mouseDragStart = crd;
            }
    
            // within is defined in utils
            if (within(crd, settings.cpPos, settings.cpSize))
                userinput.controlPanelClick([crd[0]-settings.cpPos[0],crd[1]-settings.cpPos[1]],true);
        }
        
        // mousemove is handled only if mouse down defined IsButtonDown
        // that means its a drag event. 
        // Every other function should use their own id that they give for IsButtonDown
        // and here, we can call the functions bound to the id.
    
        if (mode == "move" && this.IsButtonDown)
        {
            switch (this.IsButtonDown)
            {
                case 1:
                    map.minimap.mouseHandler(crd);
                    break;
                case 2:
                    var color = "rgba(0,255,0,1)";
                    var size = [(crd[0]-this.mouseDragStart[0]), (crd[1]-this.mouseDragStart[1])];
                    if (Math.max(Math.abs(size[0]),Math.abs(size[1]))>10)
                    {
                        var max = [Math.max(this.mouseDragStart[0],crd[0]),
                                Math.max(this.mouseDragStart[1],crd[1])];
                        var min = [Math.min(this.mouseDragStart[0],crd[0]),
                                Math.min(this.mouseDragStart[1],crd[1])];
                        this.selectBox = true;
                        this.selectBoxSpecs = [min, 
                        [(max[0]-min[0]),(max[1]-min[1])],
                        color];
                    }
                    break;
            }
        }
        
        
        // clear any drag event
        if (mode == "up")
        {
            this.IsButtonDown = 0;
            
            if (this.selectBox)
            {
                userinput.selectWithin(
                    this.convertToCell(this.mouseDragStart),
                    this.convertToCell(crd));
                this.selectBox = false;
                return;
            }
            this.selectBox = false;
            // get the ui poisitions from draw, now we know if the click is in the game
            // we can count witch cell was clicked with this pattern:
            if (within(crd,settings.visualMapPosition,settings.visualMapSize))
                this.cellClick(crd);
            if (within(crd, settings.cpPos, settings.cpSize))
                userinput.controlPanelClick([crd[0]-settings.cpPos[0],crd[1]-settings.cpPos[1]]);
        }
        
        this.gameMousePos = this.convertToCell(crd);
        
    }
    this.selectBoxSpecs = Array(3);
    this.selectBox = false;

    this.cellClick = function (crd)
    {
        var cell = this.convertToCell(crd);
        // let game handle handle the rest
        userinput.doClickCommand(cell);
    }
    
    this.convertToCell = function(crd)
    {
        if (!within(crd,settings.visualMapPosition,settings.visualMapSize))
            return false;
        // calculate the X, Y of the cell we clicked, taking in consideration the scrolling
        // scrolling means the place witch we are looking at the map.
        return [Math.floor((crd[0]-settings.visualMapPosition[0])/settings.tileSize)+map.scroll[0],
                Math.floor((crd[1]-settings.visualMapPosition[1])/settings.tileSize)+map.scroll[1]];
    }

    this.convertToGameCoords = function(crd)
    {
        var x = crd[0];
        var y = crd[1];
        
        // lets align the coordinates, so that the game window can be anywhere in the screen.
        x -= settings.canvasPos[0];
        y -= settings.canvasPos[1];
        
        // this is the main conversion, game resolution / canvas
        x = Math.round(settings.gameResolution[0]/settings.canvasSize[0]*x);
        y = Math.round(settings.gameResolution[1]/settings.canvasSize[1]*y);
        
        // lets now check that the coordinates are in the game, and fail if not.
        if (x < 0 || y < 0 || x > settings.gameResolution[0] || y > settings.gameResolution[1])
            return false;
        return [x,y];
    }
}
