function Minimap(map)
{
    this.map = map;
    this.canvas = document.createElement("canvas");
    this.ctx;
    this.minimapRelation;
    this.boxPos = Array(2);
    this.boxSize = Array(2);
    this.blackSpace = [0,0];
    this.visualMapTiles;
    this.disabled = true;
    
    this.initCanvas = function()
    {
        this.canvas.style.position = "absolute";
        this.canvas.setAttribute('height', settings.minimapSize);
        this.canvas.setAttribute('width', settings.minimapSize);
        this.canvas.style.left = settings.minimapPos[0];
        this.canvas.style.top = settings.minimapPos[1];
        this.canvas.style.zIndex = 2;
        //document.body.appendChild(this.canvas);
        this.ctx = this.canvas.getContext("2d"); 
        this.ctx.fillStyle = "rgb(0, 0, 0)";
        this.ctx.fillRect (0, 0, settings.minimapSize, settings.minimapSize);
    }
    
    this.init = function()
    {
        //alot of the minimaps metadata is in settings
        var s = settings;
        
        // lets count the size in tiles (example: 150x150 map with 15x15 tiles is 10x10)
        this.visualMapTiles = [s.visualMapSize[0]/ s.tileSize,s.visualMapSize[1]/s.tileSize];
        // get the max of map sizes x and y for refrence
        // calculate how much is one tile in minimap pixels 
        // CAUTION floating values
        
        if (this.map.mapSize[0] > this.map.mapSize[1])
        {
            this.minimapRelation = this.map.mapSize[0]/s.minimapSize;
            this.blackSpace[1] = (s.minimapSize/2)-this.map.mapSize[1]/2;
        }
        else
        {
            deb(this.map.mapSize[0]);
            this.minimapRelation = this.map.mapSize[1]/s.minimapSize;
            this.blackSpace[0] = (s.minimapSize/2)-this.map.mapSize[0]/2;
        }
    }
    
    this.drawObjectsToMinimap = function(ctx)
    {
        
        var obj = game.objects.getObjectsSortedById();
        for (o in obj)
        {
            if (!game.fow.isNotVisible(obj[o].cellXY))
            {
                draw.drawFillSquare(ctx, 
                    [(obj[o].cellXY[0]*this.minimapRelation)+settings.minimapPos[0]+this.blackSpace[0], 
                    (obj[o].cellXY[1]*this.minimapRelation)+settings.minimapPos[1]+this.blackSpace[1]],
                    [obj[o].descriptor.size[0]*this.minimapRelation, 
                    obj[o].descriptor.size[1]*this.minimapRelation],
                    settings.playerColor[obj[o].owner]
                );
            }
        }
    }
    
    this.scrollBox = function()
    {    
        var s = settings;
        // add the scroller to box's position
        this.boxPos[0] = (this.map.scroll[0]/this.minimapRelation)+this.blackSpace[0];
        this.boxPos[1] = (this.map.scroll[1]/this.minimapRelation)+this.blackSpace[1];
        // convert visual map size to minimap box size
        this.boxSize[0] = this.visualMapTiles[0]/this.minimapRelation;
        this.boxSize[1] = this.visualMapTiles[1]/this.minimapRelation;
        //deb(this.minimapBoxPos+" "+this.minimapBoxSize,1);
        return [this.boxPos[0],this.boxPos[1],this.boxSize[0],this.boxSize[1]];
    }
    
    // set coords color to some units color
    this.setCellColor = function(crd, color)
    {
        if (!map.fow.isNotVisible(crd))
        {
            draw.drawFillSquare(this.ctx
                [Math.floor(crd[0]/this.map.minimapRelation[0]+this.blackSpace[0]),
                Math.floor(crd[1]/this.map.minimapRelation[1]+this.blackSpace[1])],
                [(1/this.map.minimapRelation[0]),
                (1/this.map.minimapRelation[1])],
                color);
        }
    }
    
    // this is a nice trick, you take one pixel from an image and strech it to minimap.
    this.drawCell = function(crd, color)
    {
        if (color == undefined)
        {
            var image = "map/sand.png";
            if (this.map._mapInfo[crd[0]+","+crd[1]] == "#")
            {
                image = "map/sandrock.png";
            }
            if (this.map._mapInfo[crd[0]+","+crd[1]] == "@")
            {
                image = "map/mountainrock.png";
            }
            if (this.map.hasSpice(crd))
            {
                image = "map/spice.png";
            }
        
            draw.drawImage(this.ctx, image,
                9,9,1,1,
                (crd[0]/this.minimapRelation)+this.blackSpace[0],
                (crd[1]/this.minimapRelation)+this.blackSpace[1],
                this.minimapRelation,
                this.minimapRelation);
        }
        else {
            draw.drawFillSquare(this.ctx, 
                [Math.floor((crd[0]/this.minimapRelation)+this.blackSpace[0]),
                Math.floor((crd[1]/this.minimapRelation)+this.blackSpace[1])],
                [this.minimapRelation,
                this.minimapRelation],
                color);
        }
    }
    
    // this is called from mousecontrol
    this.getRealmapCoord = function (crd,boxpos)
    {
        var ret = Array(2);
        //alot of the minimaps metadata is in settings
        var s = settings;
        // loop 2 times, once for x, once for y
        for (var i = 0; i <= 1; i++)
        {
            // it is now real game coordinates, so
            // convert to minimap coordinates
            var MinimapCrd = crd[i]-s.minimapPos[i]-this.blackSpace[i];
            
            var is = MinimapCrd*this.minimapRelation;
            this.boxPos[i] = Math.floor(is);
        
            if (boxpos)
            {
                // minus half of the box size to coords, so that the mouse would be in the middle of the box
                MinimapCrd -= this.boxSize[i]/2;
            }
            
            // convert from minimap coord to game coord. if minimapRelation is confusing, see minimapPrecalc
            MinimapCrd = Math.round(MinimapCrd*this.minimapRelation);
        
            // check if we formed some illegal coords.
            if (MinimapCrd < 1)
                MinimapCrd = 1;
            if (MinimapCrd > this.map.mapSize[i]-this.visualMapTiles[i]) // this part's a bit more tricky
                MinimapCrd = this.map.mapSize[i]-this.visualMapTiles[i]; // basicly just checks that were
                                                                            // still on the map
            
            // finally, give the coords
            ret[i] = MinimapCrd;
        }
        
        return ret;
    }
    
    this.mouseHandler = function (crd)
    {
        this.map.scroll = this.getRealmapCoord(crd,true);
    }
    
    this.init();
    this.initCanvas();
}