function Game()
{
    var self = this;/*
    new Ajax(settings.baseDir+"/data/maps/"+settings.map+".set",
        function (data) { self.loadGame(data); } );*/
    this.objects;
    this.fow;
    this.ready = false;
    this.communication;
    this.commands;
    this.credits = Array(settings.noOfPlayers);
    
    this.afterMapInit = function(data)
    {
        //var rows = data.split("\n");
        this.objects = new GameObjects();
        this.fow = new Fow(this.objects);
        this.commands = new Commands();
        this.communication = new Communication();
        for (var i in settings.playerColor)
        {
            this.credits[i] = new Credits();
        }
    }
    
    this.canBuild = function(crd,size)
    {
        for (var y = crd[1]; y < (crd[1]+size[1]); y++)
        {
        //deb(y+" "+(parseInt(crd[1])+parsent(height)));
            for (var x = crd[0]; x < crd[0]+size[0]; x++)
            {
                if (map.getInfo([x,y]) !=  "#" || map.occupence.getOccupied([x,y]))
                {
                    return false;
                }
            }
        }
        return true;
    }
    
    this.getNearestFreeSpot = function(crd, size)
    {
        for (var x = crd[0]-1; x <= crd[0]+size[0]; x ++)
            for (var y = crd[1]-1; y <= crd[1]+size[1]; y ++)
                if (x == crd[0]-1 || x == crd[0]+size[0] ||
                    y == crd[1]-1 || y == crd[1]+size[1])
                    if (!map.occupence.getOccupied([x,y]) && 
                        (x != 0 && y != 0 && x != map.mapSize[0] && y != map.mapSize[1]))
                        return [x,y];
        return false;
    }
    
    this.drawGameObject = function(obj)
    {
        if (!obj)
            return;
        
        if (obj.isUnderConstruction && obj.descriptor.isUnit)
            return;
            
        var size = settings.tileSize;
        var imgpos = [(obj.cellXY[0]-map.scroll[0])*size+settings.visualMapPosition[0],
                      (obj.cellXY[1]-map.scroll[1])*size+settings.visualMapPosition[1]];
        if (!within(imgpos, 
        [settings.visualMapPosition[0]-size,settings.visualMapPosition[1]-size], 
        [settings.visualMapSize[0]+size,settings.visualMapSize[1]+size]))
            return;
        var img = obj.descriptor.img;
        
        var pos = [imgpos[0]+(obj.cellXYAdd[0]*size), imgpos[1]+(obj.cellXYAdd[1]*size)]
        
        // image type. here we parse the image so that we can get correct heading from it.
        if (obj.descriptor.imgtype == "long8" || obj.action == "explode")
        {
            if (obj.action != "explode")
            {
                img = img+"&color="+settings.playerColor[obj.owner]+"&datadir="+settings.dataDir;
            }
            var val = size;
            var image = draw.getImage(img); 
                if (image != undefined)
                    if (image.complete)
                        val = image.height;
                
            var offset = ((val-16)/2) / (16/size);
            var whichAnimationImage = obj.direction;
            if (obj.action == "explode")
		    whichAnimationImage = obj.explosionImage;
		    
	    
            draw.drawImage(ctx, img, whichAnimationImage*val, 0, val, val, 
            pos[0]-offset, pos[1]-offset,
            (size+offset*2)*obj.descriptor.size[0], (size+offset*2)*obj.descriptor.size[1]);
            
            if (obj.action == "harvest")
            {
                draw.drawImage(ctx, "other/harvestersand.png", obj.direction*val, 0, val, val, 
                    pos[0]-offset, pos[1]-offset,
                    size+offset*2, size+offset*2);
            }
            if (obj.fire && obj.fire != "undefined")
            {
                draw.drawImage(ctx, "shoot/"+obj.desc+".png", obj.direction*val, 0, val, val, 
                    pos[0]-offset, pos[1]-offset,
                    size+offset*2, size+offset*2);
            }
        }else if (obj.descriptor.imgtype == "troop")
        {
            if (obj.action != "explode")
            {
                img = img+"&color="+settings.playerColor[obj.owner]+"&datadir="+settings.dataDir;
                
                var shoot = false;
                if (obj.fire && obj.fire != "undefined")
                {
                    shoot = true;
                }
                
                var move = Math.round(2*(Math.max(Math.abs(obj.cellXYAdd[0]),Math.abs(obj.cellXYAdd[1]))));
                
                var numberOfUnits = 5*(obj.hp/obj.descriptor.maxhp);
                
                var unitPos = Array([4,4],[10,0],[0,0],[0,7],[10,7]);
                
                for (var i = 0; i < numberOfUnits; i ++)
                {
                    draw.drawImage(ctx, img, obj.direction*6, move*8, 6, 8, 
                        pos[0]+unitPos[i][0], pos[1]+unitPos[i][1],
                        6, 8);
                    if (shoot)
                    {
                        draw.drawImage(ctx, "shoot/"+obj.desc+".png", obj.direction*6, 0, 6, 8, 
                        pos[0]+unitPos[i][0], pos[1]+unitPos[i][1],
                        6, 8);
                    }
                }
            }
            else
            {
                img = "bullets/blood.png";
                draw.drawImage(ctx, img, pos[0]+4, pos[1]+4,8,8);
            }
        } else if (obj.descriptor.imgtype == "static")
        {
            if (obj.isUnderConstruction)
                img = "buildings/foundation2.png";
            draw.drawImage(ctx, img, imgpos[0], imgpos[1], 
                size*obj.descriptor.size[0],size*obj.descriptor.size[1]);
        }
        if (userinput.selected != undefined)
        {
            for (var o in userinput.selected)
                if (userinput.selected[o].id == obj.id)
                    draw.drawSquare(ctx, pos, 
                        [size*obj.descriptor.size[0],size*obj.descriptor.size[1]],
                        settings.playerColor[obj.owner]);
        }
    }
    
    
    this._gameStateDebug = "";
    this.getGameStateChecksum = function() {
        var datastr = ''; // Game data is collected here. This will be CRC32'ed.

        function add(data) {
            datastr += data.toString()+", ";
        }
        
        var objects = self.objects.getObjectsSortedById();
        for (var i = 0; i < objects.length; ++i) {
            var obj = objects[i];
            add(obj.id);
            add(obj.cellXY);
            add(obj.owner);
            add(obj.isUnderConstruction);
            add(obj.attackTarget);
            add(obj.destXY);
            datastr += "\n<br>";
        }
        
        this._gameStateDebug = datastr;
        
        debugLog(datastr);

        return crc32(datastr);
    }
}