// this is the fog of war
// on every unit's calc, we define witch tiles are visible
// after every frame, we fog every visible tile, so that when we calc visibility again,
// foggy tiles are fogged, and only visible are visible.
// if a tile has never been visible, it will be left black

function Fow(objects)
{
    var self = this;
    // visibility layer, array[x+","+y] undefined = not visible, false = foggy, true = visible
    this._visible = Array();
    this.objects = objects;
    
    this.sight = function(obj)
    {
        if (obj.owner != settings.playerId)
            return;
        
        var crd = obj.cellXY;
        var objSize = obj.descriptor.size;
        var sight = obj.sight;
        for (var x = (crd[0]-2); x <= (crd[0]+objSize[0]+1); x ++)
            for (var y = (crd[1]-2); y <= (crd[1]+objSize[1]+1); y ++)
            {
                if (this._visible[x+","+y] == undefined)
                {
                    map.minimap.drawCell([x,y]);
                }
                this._visible[x+","+y] = true;
            }
    }
    
    this.update = function()
    {
        this.fogAll();
        
        for (var o in this.objects._obj)
            this.sight(this.objects._obj[o]);
    }
    
    this.fogAll = function()
    {
        for (f in this._visible)
            this._visible[f] = false;
    }
    
    // takes, array(2) coords
    // returns 0,1,2
    // 0 = is visible
    // 1 = fogged
    // 2 = invisible
    this.isNotVisible = function(crd)
    {
        if (this._visible[crd[0]+","+crd[1]] == undefined)
            return 2;
        if (this._visible[crd[0]+","+crd[1]] == false)
            return 1;
        return 0;
    }
}