function ArtificialIntelligence(commands)
{
    this.commands = commands;
    var self = this;
    
    this.updateAI = function(obj)
    {
    
        if (!obj.action)
        {
            
            if (obj.attackTarget)
            {
                // set attack target pos as our destonation
                obj.destXY = obj.attackTarget.cellXY;
                // check if were within the attack range
                if (!game.objects.isNextTo(obj.cellXY, obj.attackTarget.id, obj.descriptor.attackRange))
                {
                }
                else
                {
                    // if we are, check if were heading twoards it.
                    if (Calc.getHeading(obj.cellXY, obj.attackTarget.cellXY) != obj.direction)
                    {
                        obj.action = "turn";
                        actions.addAction(actions.getTime()+obj.descriptor.actionTimeLength["turn"], 
                            function() {
                                self.commands.turn(obj, obj.attackTarget.cellXY);
                                obj.action = false;
                            }
                        );
                    }
                    else
                    {
                        // everything ok, shoot!
                        obj.action = "shoot";
                        actions.addAction(actions.getTime(), 
                            function(p)
                            {
                                self.commands.shoot(p, obj);
                            },     obj.descriptor.actionTimeLength["shoot"]
                        );
                    }
                    return;
                }
                    
            }
            else
            {/*
                // check if there are enemies nearby
                var nearEnemy = game.objects.getNearestEnemy(obj.cellXY,obj.attackRange)
                if (nearEnemy)
                {
                }*/
            }
                
            
            if (obj.harvest)
            {
                if (obj.spice >= obj.descriptor.storage)
                {
                    var refinery = game.objects.getNearestFreeRefinery(obj.cellXY);
                    
                    if (refinery && refinery.owner == obj.owner)
                    {
                        if (!game.objects.isNextTo(obj.cellXY, refinery.id))
                        {
                            obj.destXY = refinery.cellXY;
                        }
                        else
                        {
                            var otherHarvester = game.objects.getObjectById(
                                map.occupence.getOccupied([refinery.cellXY[0]+2,refinery.cellXY[1]]));
                            if (otherHarvester.desc != "refinery")
                            {
                                obj.destXY = obj.cellXY;
                                obj.action = "wait";
                                actions.addAction(actions.getTime()+
                                    obj.descriptor.actionTimeLength["wait"],
                                    function () { obj.action = false; });
                            }
                            else
                            {
                                deb("docking")
                                // dock the harvester to the refinery
                                map.occupence.unoccupy(obj.cellXY);
                                map.occupence.unoccupy([refinery.cellXY[0]+2,refinery.cellXY[1]]);
                                map.occupence.occupy([refinery.cellXY[0]+2,refinery.cellXY[1]], obj.id);
                                obj.direction = 6;
                                obj.cellXY = [refinery.cellXY[0]+2,refinery.cellXY[1]];
                                obj.cellXYAdd = [0,0.5];
                                obj.destXY = obj.cellXY;
                                obj.action = "unloadspice";
                                actions.addAction(actions.getTime()+
                                    obj.descriptor.actionTimeLength["unloadspice"],
                                    function () { self.commands.unloadspice(obj); });
                            }
                        }
                    }
                    else
                    {
                        obj.destXY = obj.cellXY;
                        obj.action = "wait";
                        actions.addAction(actions.getTime()+
                            obj.descriptor.actionTimeLength["wait"],
                            function () { 
                                if (!obj)
                                    return; 
                                obj.action = false; 
                            });
                    }
                }
                else if (!map.hasSpice(obj.cellXY))
                {
                    if (obj.cellXY[0] == obj.destXY[0] && obj.cellXY[1] == obj.destXY[1])
                    {
                        var dest = map.getNearestSpice(obj.cellXY);
                        if (dest)
                            obj.destXY = dest;
                        else
                        {
                            toplayer.setGameMessage("Harvester: Nothing to harvest");
                            obj.harvest = false;
                        }
                    }
                }
                else
                {
					obj.action = "harvest";
					actions.addAction(
						actions.getTime()+obj.descriptor.actionTimeLength["harvest"],
						function() {
							if (map.takeSpice(obj.cellXY))
							{
                                if (!obj)
                                    return; 
                                
								if (obj.spice)
									obj.spice = obj.spice+settings.spiceModifier;
								else
									obj.spice = settings.spiceModifier;
							}
							obj.action = false;
						}
					);
				}
            }
            if (obj.destXY[0] != obj.cellXY[0] || obj.destXY[1] != obj.cellXY[1])
            {
                obj.action = "nextmove";
                actions.addAction(actions.getTime(), function() {
                    if (!obj)
                        return; 
                    self.commands.moveNext(obj, obj.destXY);
                })
            }
        }
    }
    
    
    this.ultimateLoop = function()
    {
        var objects = game.objects.getObjectsSortedById();
        for (var i = 0; i < objects.length; ++i)
            this.updateAI(objects[i]);
        
        
        actions.addAction(actions.getTime()+200, function () {
            self.ultimateLoop();
        });
    }
    this.ultimateLoop();
}