/*
 *  Copyright (C) 2008 Tuomas Peippo
 *
 *  This program is distributed under the terms of the
 *  GNU General Public License.
 *
 *  This file is part of Dave the Ordinary Spaceman.
 *
 *  Dave the Ordinary Spaceman is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Dave the Ordinary Spaceman is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Dave the Ordinary Spaceman. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _TELETEXT_EDITOR_
#define _TELETEXT_EDITOR_

#include <string>
#include <map>
#include <vector>
#include "level.h"
#include "teletext.h"
#include "analog_effects.h"
#include "editor.h"

#include "vector.h"

struct Color {
//  Color(float r, float g, float b, float a) {
//    this.r =r;this.g=g;this.b=b;this.a=a;
//  }
  float r;
  float g;
  float b;
  float a;
  
};

static bool showCurrentColor;
static bool showCurrentBgColor;

std::map<std::string, Color> colors;


using namespace std;

class SDL_Surface;
class Scene;

class TeletextEditor
{
public:
  TeletextEditor(char *pic);
  ~TeletextEditor();

  int run();
  void drawBg();
  void drawCursor();
  void drawText();
  void handleText(SDL_KeyboardEvent key);
  void showColor(Color color);
  static Uint32 hideCurrentColorBox(Uint32 interval, void *param);

private:

  void handle();
  void loadFile(const std::string &name);
  void saveFile(const std::string &name);
  
  int width;
  int height;
  /*debug*/public:
    void render();private:
 
std::vector<Teletext*> texts;

std::vector<std::string> fgColors;
std::vector<std::string> bgColors;

  SDL_Surface *screen;
Vector cursor;
Vector cursorSize;
Image *bg;

std::string currentColor;
std::string currentBgColor;
SDL_TimerID timerID;

bool cursorUp;
bool cursorDown;
bool cursorRight;
bool cursorLeft;


  bool running;                    // false jos peli lopetetaan, muuten true
  
 
};

extern TeletextEditor *teletextEditor;

#endif
