/*
 *  Copyright (C) 2008 Kristian Kristola
 *
 *  This program is distributed under the terms of the
 *  GNU General Public License.
 *
 *  This file is part of Dave the Ordinary Spaceman.
 *
 *  Dave the Ordinary Spaceman is free software: you can redistribute
 *  it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Dave the Ordinary Spaceman is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Dave the Ordinary Spaceman. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef _LIBRARY_ON_HYVAA_KUN_YKSIN_SYO_
#define _LIBRARY_ON_HYVAA_KUN_YKSIN_SYO_

#include <string>
#include <map>

using namespace std;

class LibraryEntry;
class Image;

class Library
{
private:
  static bool instantiated;

  map<string, LibraryEntry *> entries;
  LibraryEntry *load_file(string filename);

public:
  Library();
  ~Library();

  bool load_everything();
  LibraryEntry *get(string name);
  Image *operator[](string name);
};

extern Library lib;

#endif
