uniform sampler2D blurred, current;
uniform float interlace_turn;
uniform float chroma;
uniform float mblur_amount;
uniform float posz_amount;
varying vec2 uv;

void main(void)
{
  vec4 o;
  vec4 current_color;
  vec4 blurred_color;
  vec4 new_blurred_color;
  float inf;
  vec4 monochrome;
  const float rows = 10.0;

  o = texture2D(current, uv);    //   gl_FragColor = o; return;

  current_color = o;
#if 0
  if (mblur_amount < 0.3) {
    current_color = vec4(0.0);
    for   (float x=-2.0; x<=2.0; x+=2.0)
      for (float y=-2.0; y<=2.0; y+=2.0)
	current_color += texture2D(current, uv + vec2(x, y) / vec2(800.0, 600.0));
    current_color /= 3.0 * 3.0;
  }
#endif

  // Overlay
  //current_color = ((1.0 - o) * 2.0 * current_color + o) * o;
  // Inverse overlay
  //current_color = ((1.0 - current_color) * 2.0 * o + current_color) * current_color;
  // Average
  //current_color = 0.5 * o + 0.5 * current_color;
  // Addition
  //current_color += o;
  // Lighten only
  //current_color = mix(max(o, current_color), o, 0.5);
  // Ihme(tm)
  //current_color = o;

  blurred_color = texture2D(blurred, uv);

  // Posterization
#if 1
  current_color = mix(current_color, floor(current_color * 5.0) / 5.0, posz_amount);   // a good one: 5.0

  // Contrast
  current_color *= mix(1.0, 1.3, posz_amount);
#endif

  // Chroma
#if 1
  //monochrome.r = (current_color.r + current_color.g + current_color.b) / 3.0;  // proper
  //monochrome.gba = vec3(monochrome.r, monochrome.r, 1.0);
  //current_color = mix(monochrome, current_color, chroma);

  monochrome.r = (current_color.r + current_color.g + current_color.b) / 3.0;  // only one component
  monochrome.gba = vec3(current_color.g, current_color.b, 1.0);
  current_color = mix(monochrome, current_color, chroma);

  //current_color = min(mix(vec4(sin(current_color.rgb + vec3(1.0) /*, 2.5*/) - vec3(1.0), 1.0), current_color, chroma), vec4(1.0));
  //current_color = min(current_color, vec4(1.0));
  //current_color = current_color;
#endif

  // Interlacing
#if 0
  inf = mod(gl_FragCoord.y, 4.0);
//inf = mod(uv.t, 1.0 / rows * 2.0) * rows / 2.0 * 4.0;
  inf = clamp(inf, 1.5, 2.5) - 1.5;
  inf = mix(1.0 - inf, inf, interlace_turn);
  current_color = mix(blurred_color, current_color, inf);
#endif

  // Motion blur
  new_blurred_color = mix(blurred_color, current_color, mblur_amount);   // a good one: 0.3, 0.55

  gl_FragColor = new_blurred_color;
}
