/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Cursor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.AWTUtil;
import org.lwjgl.opengl.AbstractAWTInput;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.WindowsDirectInput;
import org.lwjgl.opengl.WindowsDirectInputMouse;
import org.lwjgl.opengl.WindowsDisplay;
import org.lwjgl.opengl.WindowsPeerInfo;

final class WindowsAWTInput
extends AbstractAWTInput {
    private static final int WS_CHILD = 0x40000000;
    private final Cursor blank_cursor;
    private Cursor cached_cursor;
    private long cached_hwnd;
    private WindowsDirectInputMouse cached_mouse;
    private boolean has_grabbed;

    public WindowsAWTInput(AWTGLCanvas canvas) throws LWJGLException {
        super(canvas);
        int w = AWTUtil.getMinCursorSize();
        int h = AWTUtil.getMinCursorSize();
        this.blank_cursor = AWTUtil.createCursor(w, h, 0, 0, 1, BufferUtils.createIntBuffer(w * h), null);
    }

    public synchronized void destroyMouse() {
        if (this.cached_mouse != null) {
            this.grab(false);
            this.cached_mouse.destroy();
            this.cached_mouse = null;
        }
        super.destroyMouse();
    }

    public synchronized void processInput(PeerInfo peer_info) {
        WindowsPeerInfo windows_peerinfo = (WindowsPeerInfo)peer_info;
        long hwnd = windows_peerinfo.getHwnd();
        try {
            hwnd = WindowsAWTInput.findTopLevelWindow(hwnd);
            if (this.cached_mouse == null || hwnd != this.cached_hwnd) {
                this.has_grabbed = false;
                this.cached_hwnd = hwnd;
                if (this.cached_mouse != null) {
                    this.cached_mouse.destroy();
                }
                WindowsDirectInput dinput = WindowsDisplay.createDirectInput();
                this.cached_mouse = new WindowsDirectInputMouse(dinput, hwnd);
            }
            if (this.isGrabbed()) {
                WindowsDisplay.setupCursorClipping(hwnd);
                if (this.getCanvas().getCursor() != this.blank_cursor) {
                    this.cached_cursor = this.getCanvas().getCursor();
                    this.getCanvas().setCursor(this.blank_cursor);
                }
            } else {
                WindowsDisplay.resetCursorClipping();
            }
            this.grab(this.isGrabbed());
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Failed to create windows mouse: " + e);
        }
    }

    private static native int getWindowStyles(long var0) throws LWJGLException;

    private static native long getParentWindow(long var0);

    private static long findTopLevelWindow(long hwnd) throws LWJGLException {
        int window_styles = WindowsAWTInput.getWindowStyles(hwnd);
        while ((window_styles & 0x40000000) != 0) {
            hwnd = WindowsAWTInput.getParentWindow(hwnd);
            window_styles = WindowsAWTInput.getWindowStyles(hwnd);
        }
        return hwnd;
    }

    private void grab(boolean grab) {
        if (this.has_grabbed != grab) {
            this.cached_mouse.grab(grab);
            this.has_grabbed = grab;
            this.cached_mouse.flush();
            this.getMouseEventQueue().clearEvents();
            if (!grab) {
                this.getCanvas().setCursor(this.cached_cursor);
            }
        }
    }

    public synchronized void grabMouse(boolean grab) {
        if (grab != this.isGrabbed()) {
            if (this.cached_mouse != null && !grab) {
                this.grab(grab);
            }
            super.grabMouse(grab);
        }
    }

    public synchronized void pollMouse(IntBuffer coord_buffer, ByteBuffer buttons) {
        if (this.isGrabbed()) {
            if (this.cached_mouse != null) {
                this.cached_mouse.poll(coord_buffer, buttons);
            }
        } else {
            super.pollMouse(coord_buffer, buttons);
        }
    }

    public synchronized void readMouse(ByteBuffer buffer) {
        if (this.isGrabbed()) {
            if (this.cached_mouse != null) {
                this.cached_mouse.read(buffer);
            }
        } else {
            super.readMouse(buffer);
        }
    }
}

