/*
 * Decompiled with CFR 0.152.
 */
package idx3d;

import idx3d.idx3d_Color;
import idx3d.idx3d_Math;
import idx3d.idx3d_Texture;
import idx3d.idx3d_TextureFactory;
import idx3d.idx3d_TextureSettings;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class idx3d_Material {
    int color;
    int transparency;
    int reflectivity = 255;
    idx3d_Texture texture;
    idx3d_Texture envmap;
    boolean flat;
    boolean wireframe;
    boolean opaque = true;
    String texturePath;
    String envmapPath;
    public idx3d_TextureSettings textureSettings;
    public idx3d_TextureSettings envmapSettings;

    public void setTexture(idx3d_Texture idx3d_Texture2) {
        this.texture = idx3d_Texture2;
        if (this.texture != null) {
            this.texture.resize();
        }
    }

    public idx3d_Texture getTexture() {
        return this.texture;
    }

    public void setFlat(boolean bl) {
        this.flat = bl;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setTransparency(int n) {
        this.transparency = idx3d_Math.crop(n, 0, 255);
        this.opaque = this.transparency == 0;
    }

    public int getTransparency() {
        return this.transparency;
    }

    private void readTexture(DataInputStream dataInputStream, Object object, boolean bl) throws IOException {
        idx3d_Texture idx3d_Texture2 = null;
        byte by = dataInputStream.readByte();
        if (by == 1) {
            idx3d_Texture2 = object instanceof URL ? new idx3d_Texture((URL)object, dataInputStream.readUTF()) : new idx3d_Texture((String)object + dataInputStream.readUTF());
            if (idx3d_Texture2 != null && bl) {
                this.texturePath = idx3d_Texture2.path;
                this.textureSettings = null;
                this.setTexture(idx3d_Texture2);
            }
            if (idx3d_Texture2 != null && !bl) {
                this.envmapPath = idx3d_Texture2.path;
                this.envmapSettings = null;
                this.setEnvmap(idx3d_Texture2);
            }
        }
        if (by == 2) {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            byte by2 = dataInputStream.readByte();
            float f = dataInputStream.readFloat();
            float f2 = dataInputStream.readFloat();
            int n3 = dataInputStream.readUnsignedByte();
            int n4 = dataInputStream.readUnsignedByte();
            int[] nArray = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                nArray[n5] = dataInputStream.readInt();
                ++n5;
            }
            if (by2 == 1) {
                idx3d_Texture2 = idx3d_TextureFactory.PERLIN(n, n2, f, f2, n3, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
            }
            if (by2 == 2) {
                idx3d_Texture2 = idx3d_TextureFactory.WAVE(n, n2, f, f2, n3, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
            }
            if (by2 == 3) {
                idx3d_Texture2 = idx3d_TextureFactory.GRAIN(n, n2, f, f2, n3, 20, 1024).colorize(idx3d_Color.makeGradient(nArray, 1024));
            }
            if (bl) {
                this.texturePath = null;
                this.textureSettings = new idx3d_TextureSettings(idx3d_Texture2, n, n2, by2, f, f2, n3, nArray);
                this.setTexture(idx3d_Texture2);
                return;
            }
            this.envmapPath = null;
            this.envmapSettings = new idx3d_TextureSettings(idx3d_Texture2, n, n2, by2, f, f2, n3, nArray);
            this.setEnvmap(idx3d_Texture2);
        }
    }

    public void setWireframe(boolean bl) {
        this.wireframe = bl;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setEnvmap(idx3d_Texture idx3d_Texture2) {
        this.envmap = idx3d_Texture2;
        idx3d_Texture2.resize(256, 256);
    }

    public idx3d_Texture getEnvmap() {
        return this.envmap;
    }

    private void readSettings(DataInputStream dataInputStream) throws IOException {
        this.setColor(dataInputStream.readInt());
        this.setTransparency(dataInputStream.readUnsignedByte());
        this.setReflectivity(dataInputStream.readUnsignedByte());
        this.setFlat(dataInputStream.readBoolean());
    }

    public boolean isWireframe() {
        return this.wireframe;
    }

    public void setReflectivity(int n) {
        this.reflectivity = idx3d_Math.crop(n, 0, 255);
    }

    public int getReflectivity() {
        return this.reflectivity;
    }

    private void importFromStream(InputStream inputStream, Object object) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.readSettings(dataInputStream);
        this.readTexture(dataInputStream, object, true);
        this.readTexture(dataInputStream, object, false);
    }

    public idx3d_Material() {
    }

    public idx3d_Material(int n) {
        this.setColor(n);
    }

    public idx3d_Material(idx3d_Texture idx3d_Texture2) {
        this.setTexture(idx3d_Texture2);
        this.reflectivity = 255;
    }

    public idx3d_Material(URL uRL, String string) {
        int n = 0;
        String string2 = uRL.toString();
        while (string2.indexOf("/", n) > 0) {
            n = string2.indexOf("/", n) + 1;
        }
        string2 = string2.substring(0, n) + string;
        while (string2.indexOf("/", n) > 0) {
            n = string2.indexOf("/", n) + 1;
        }
        String string3 = string2.substring(n);
        String string4 = string2.substring(0, n);
        try {
            this.importFromStream(new URL(string4 + string3).openStream(), new URL(string4));
            return;
        }
        catch (Exception exception) {
            System.err.println(exception + "");
            return;
        }
    }

    public idx3d_Material(String string) {
        String string2 = string.substring(0, string.length() - new File(string).getName().length());
        try {
            this.importFromStream(new FileInputStream(new File(string)), string2);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception + "");
            return;
        }
    }
}

