/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Context;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.RenderTexture;

public final class Pbuffer
implements Drawable {
    public static final int PBUFFER_SUPPORTED = 1;
    public static final int RENDER_TEXTURE_SUPPORTED = 2;
    public static final int RENDER_TEXTURE_RECTANGLE_SUPPORTED = 4;
    public static final int RENDER_DEPTH_TEXTURE_SUPPORTED = 8;
    public static final int MIPMAP_LEVEL = 8315;
    public static final int CUBE_MAP_FACE = 8316;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_X = 8317;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_X = 8318;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Y = 8319;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Y = 8320;
    public static final int TEXTURE_CUBE_MAP_POSITIVE_Z = 8321;
    public static final int TEXTURE_CUBE_MAP_NEGATIVE_Z = 8322;
    public static final int FRONT_LEFT_BUFFER = 8323;
    public static final int FRONT_RIGHT_BUFFER = 8324;
    public static final int BACK_LEFT_BUFFER = 8325;
    public static final int BACK_RIGHT_BUFFER = 8326;
    public static final int DEPTH_BUFFER = 8359;
    private final PeerInfo peer_info;
    private final int width;
    private final int height;
    private final Context context;
    private boolean destroyed;

    public Pbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture, Drawable shared_drawable) throws LWJGLException {
        this.width = width;
        this.height = height;
        this.peer_info = Pbuffer.createPbuffer(width, height, pixel_format, renderTexture);
        Context shared_context = null;
        if (shared_drawable != null) {
            shared_context = shared_drawable.getContext();
        } else {
            Drawable display_drawable = Display.getDrawable();
            if (display_drawable != null) {
                shared_context = display_drawable.getContext();
            }
        }
        this.context = new Context(this.peer_info, shared_context);
    }

    private static PeerInfo createPbuffer(int width, int height, PixelFormat pixel_format, RenderTexture renderTexture) throws LWJGLException {
        if (renderTexture == null) {
            return Display.getImplementation().createPbuffer(width, height, pixel_format, null, null);
        }
        return Display.getImplementation().createPbuffer(width, height, pixel_format, renderTexture.pixelFormatCaps, renderTexture.pBufferAttribs);
    }

    public Context getContext() {
        return this.context;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Pbuffer is destroyed");
        }
    }

    public synchronized boolean isBufferLost() {
        this.checkDestroyed();
        return Display.getImplementation().isBufferLost(this.peer_info);
    }

    public synchronized void makeCurrent() throws LWJGLException {
        this.checkDestroyed();
        this.context.makeCurrent();
    }

    public static int getCapabilities() {
        return Display.getImplementation().getPbufferCapabilities();
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        try {
            this.context.forceDestroy();
            this.peer_info.destroy();
            this.destroyed = true;
        }
        catch (LWJGLException e) {
            LWJGLUtil.log("Exception occurred while destroying pbuffer: " + e);
        }
    }

    public synchronized void setAttrib(int attrib, int value) {
        this.checkDestroyed();
        Display.getImplementation().setPbufferAttrib(this.peer_info, attrib, value);
    }

    public synchronized void bindTexImage(int buffer) {
        this.checkDestroyed();
        Display.getImplementation().bindTexImageToPbuffer(this.peer_info, buffer);
    }

    public synchronized void releaseTexImage(int buffer) {
        this.checkDestroyed();
        Display.getImplementation().releaseTexImageFromPbuffer(this.peer_info, buffer);
    }

    public synchronized int getHeight() {
        this.checkDestroyed();
        return this.height;
    }

    public synchronized int getWidth() {
        this.checkDestroyed();
        return this.width;
    }

    static {
        Sys.initialize();
    }
}

