uniform sampler2D texture1;
uniform sampler2D texture2;
uniform samplerCube envmap;

uniform float interpc;

void main ()
{
	float interpn = interpc;
	float interp  = 1.0 - interpc;

	vec4 rfrag1 = texture2D(texture1, gl_TexCoord[0].st);
	vec4 rfrag2 = texture2D(texture2, gl_TexCoord[0].st);

	vec4 intfrag = vec4((rfrag1.r * interp) + (rfrag2.r * interpn), 
			    (rfrag1.g * interp) + (rfrag2.g * interpn), 
			    (rfrag1.b * interp) + (rfrag2.b * interpn), 1.0);
	
	intfrag = normalize(vec4((intfrag.r-0.5)*2.0, (intfrag.g - 0.5)*2.0, (intfrag.b-0.5)*2.0, 1.0));

	vec3 intfrag3 = vec3(intfrag);
	vec3 normmat = normalize(gl_NormalMatrix * intfrag3);

	vec3 envColor = vec3(textureCube(envmap, normmat));	

	gl_FragColor = vec4(envColor.r, envColor.g, envColor.b * 1.5, 0.0);
}