float4x4 mVP; // View * Projection matrix


struct SInput {
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
};

SInput RenderSceneVS( SInput i )
{
	SInput o;
	
	o.pos = mul( i.pos, mVP );			
	o.diffuse = i.diffuse; 
	
	return o;   
}



technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = NULL;
		
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		SeparateAlphaBlendEnable = True;
		SrcBlendAlpha = One;
		DestBlendAlpha = One;
		
		CullMode = None;

		//ZEnable = False;
		//ZWriteEnable = False;
		
		ZEnable = True;
		ZWriteEnable = False;
		
		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}
}
