#include "ZenitShared.fx"

texture tEnv;
texture tBase;

sampler BaseSampler = sampler_state {
    Texture = <tBase>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};

sampler EnvSampler = sampler_state {
    Texture = <tEnv>;    
    MipFilter = Linear; MinFilter = Linear; MagFilter = Linear;
};


struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
	float2 texe : TEXCOORD1;
};

struct SOutput
{
	float4 pos : POSITION;
	float4 diffuse : COLOR0;
	float2 tex : TEXCOORD0;
	float2 texe : TEXCOORD1;
};


SOutput RenderSceneVS( SInput i )
{
	SOutput o;
	
	float3 pos, normal;
	
	gSkinning( i.pos, i.normal, i.index, pos, normal );	
	
	float3 toPos = pos - vCameraPos;
	float3 reflection = normalize( reflect( toPos, normal ) );
	o.texe = float2(
		 reflection.x * 0.5 / 16 + 0.5 / 16 + i.texe.x,
		-reflection.y * 0.5 + 0.5
	);
	
	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.tex = i.tex; 
	
	//o.diffuse = gLightDiffuse * max( 0, dot( normal, gLightDir ) ) + gLightAmbient;
	o.diffuse = 
		gLightDiffuse * max( 0, dot( normal, gLightDir ) ) * 0.5
		+ i.texe.y
		+ gLightAmbient;
	//o.diffuse = i.texe.y + 0.3;
	//o.diffuse *= 1.3;

	return o;   
}


float4 RenderScenePS( SOutput i ) : COLOR
{ 
	//return i.diffuse;
	return  tex2D( EnvSampler, i.texe ) * 0.5 +
		tex2D( BaseSampler, i.tex ) * i.diffuse;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVS();
		PixelShader  = compile ps_1_1 RenderScenePS();
		
		AlphaBlendEnable = False;
		ZEnable = True;
		ZWriteEnable = True;
		CullMode = <iCull>;
	}
}
