//#include "ZenitShared.fx"

float4x4 mVP;	// View * Projection matrix
float3 vCameraPos;

//texture tBase;
float4x4 mWorld;

struct SInput {
	float4 pos : POSITION;
	float4 index : BLENDINDICES;
        float3 normal : NORMAL;
        float2 tex : TEXCOORD0;
};

struct SOutput
{
    float4 pos : POSITION;
    float4 diffuse : COLOR0;
};


SOutput RenderSceneVSNormal( SInput i )
{
	SOutput o;
	
	float3 normal, pos;
	
	pos = mul( i.pos, mWorld );   
	normal = normalize( mul( i.normal, (float3x3)mWorld ) ); 

	o.pos = mul( float4( pos, 1 ), mVP );
		
	o.diffuse.a = 1;
	o.diffuse.rgb = normalize( normal ) * 0.5 + 0.5; //- float3( 0.5, 0.5, 0.5 );
	o.diffuse.rgb = 1;
	//o.diffuse = float4( 0.05, 0.95, 0.045, 0.1 );
	//o.diffuse = float4( 1, 1, 1, 0.2 );
	o.diffuse = float4( 1, 1, 1, 0.1 );
	
	return o;   
}


SOutput RenderSceneVSFar( SInput i )
{
	SOutput o;
	
	float3 pos;
	
	pos = mul( i.pos, mWorld );   

	float3 fromCamera = normalize( pos - vCameraPos ) * 2500;
	pos = vCameraPos + fromCamera;	
	
	o.pos = mul( float4( pos, 1 ), mVP );
		
	//o.diffuse = float4( 0.05, 0.05, 0.5, 1 );	
	//o.diffuse = float4( 118/256, 118/256, 106/256, 1 );	
	o.diffuse = float4( 100.0/256, 100.0/256, 80.0/256, 1 );	
	
	return o;   
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 RenderSceneVSNormal();
		PixelShader  = NULL;
		
		AlphaBlendEnable = False;
		
		//CullMode = CCW;
		CullMode = None;

		ZEnable = True;
		ZWriteEnable = False;

		StencilEnable = True;
		StencilFunc = Equal;
		StencilPass = Replace;
		StencilFail = Keep;
		StencilZFail = Keep;
		

		ColorOp[0] = SelectArg1;
		ColorArg1[0] = Diffuse;
		AlphaOp[0] = SelectArg1;
		AlphaArg1[0] = Diffuse;
		
		ColorOp[1] = Disable;
		AlphaOp[1] = Disable;
	}

	pass P1 {          
		VertexShader = compile vs_1_1 RenderSceneVSFar();
	
//STENCILENABLE = False;
		//StencilEnable = True;
		StencilFunc = Equal;
		StencilFail = Keep;
		StencilZFail = Keep;
		StencilPass = Keep;
		ZEnable = True;
		ZFunc = Always;
		ZWriteEnable = True;
	}

	pass P2 {
		VertexShader = compile vs_1_1 RenderSceneVSNormal();

		//StencilFunc = Equal;
		//STENCILENABLE = False;
		StencilEnable = True;

		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

		CullMode = None;
	
		ZEnable = True;
//		ZFunc = Always;
		ZWriteEnable = True;
	}
}
