#include "Shared.fx"

struct SPosDiffTex {
	float4 pos : POSITION;
	float4 col : COLOR0;
        float2 tex : TEXCOORD0;
};

float4 vCol;

SPosDiffTex transformVP1( SPosTex i )
{
	SPosDiffTex o;
	
	float4 pos = mul( i.pos, mWorld );
	//pos.xyz *= 0.1;
	pos.xz *= 0.5;
	//float f = 1;
	//float f2 = 1;
	//pos.x = pow(pos.x / f2, f);
	//pos.y = pow(pos.y / f2, f);
	//pos.z = pow(pos.z / f2, f);
	o.pos = mul( pos, mVP );
	//o.pos.x += 50;
	o.tex = i.tex;
	o.col = 1 - clamp((abs(pos.y) - 200) / 600, 0, 1);

	return o; 
}

float4 RenderScenePS( SPosDiffTex i ) : COLOR
{ 
	//return float4( 0, 0, 0, 0.5 );
	//return float4( 0.84, 0.90, 0.80, 1 );
	//return float4( 0.48, 0.49, 0.33, 1 );
	return vCol;

	float4 col = tex2D( smpBase, i.tex );
	//col.a = ( 1 - col.r ) * 0.7;
	col.a = ( 1 - col.r ) * 2;
	//col.rgb = 1;
	//col.rgb = 0;
	//col.a *= i.col.a;

	col.rgb = vCol.rgb;

	return col;

	//return 1;
}


technique RenderScene {
	pass P0 {          
		VertexShader = compile vs_1_1 transformVP1();
		PixelShader  = compile ps_2_0 RenderScenePS();
	
		ZEnable = False;
		ZWriteEnable = False;
		CullMode = None;

		AlphaBlendEnable = True;

		SrcBlend = SrcAlpha;
		//SrcBlend = One;
		DestBlend = InvSrcAlpha;
		//DestBlend = One;

		//FillMode = Wireframe;
	}
}

	
