uniform samplerCube environ;

varying vec3 varyEyeVec;
varying vec3 varyNormal;
varying vec2 texCoords;

void main(void)
{
   vec3 normal = normalize(varyNormal);
   // Look up environment map value in cube map
   vec4 envColor = vec4( textureCube(environ, normalize(varyEyeVec)));
   envColor.rgb*=envColor.a;
   
   vec3 lightVec = vec3(0.4,0.8,-0.8);
   lightVec = normalize(lightVec);
   float lightRec = max(dot(normal,normalize(varyEyeVec)),0.2);

   vec3 lolCol = vec3(0.9,0.5,0.5);
   gl_FragColor = vec4(lolCol*lightRec+envColor.rgb, 1.0);
}