attribute vec3 normals;
attribute vec2 texCoord1;
varying vec2 texCoord;
varying vec3 norm;
varying vec3 eyeVec;
varying vec3 lightVec;
uniform vec3 lightPos;
uniform mat4 exfCamInverse;
uniform vec3 cameraPos;
void main()
{
 mat3 camRotInv;
 camRotInv[0] = exfCamInverse[0].xyz;
 camRotInv[1] = exfCamInverse[1].xyz;
 camRotInv[2] = exfCamInverse[2].xyz;
 norm = (camRotInv*gl_NormalMatrix)*normals;
 vec3 lightPosSpaced = (exfCamInverse*gl_ModelViewMatrix*vec4(lightPos,1.0)).xyz;
 eyeVec =  (exfCamInverse*gl_ModelViewMatrix*gl_Vertex).xyz - cameraPos;
 lightVec = normalize(reflect(normalize(eyeVec),normalize(norm)));
 texCoord = texCoord1;
 gl_Position = ftransform();

}