varying vec2 texCoord;
uniform sampler2D baseMap;
uniform sampler2D bozlolMap;
uniform samplerCube envMap;
varying float height;
float radius = 650;
uniform vec3 spherePos;
uniform vec3 spherePos2;
varying vec3 fragPos;
varying vec3 eyeVec;
varying vec3 norm;

void main()
{
float eta= 0.85;
float colMix = 0.2;
float boozeMix = 0.0;
//if fragPos is inside the sphere. then discard it.
float dist = length(spherePos - fragPos);
bool discarder = false;
if(dist < radius)
discarder=true;

dist = length(spherePos2 - fragPos);
if(dist < radius)
if(discarder==true)
discarder = true;
else
discarder=true;

//discarder=false;
if(discarder)
discard;
boozeMix=0.5;

colMix = (dist)/(radius);

vec4 col = texture2D(baseMap,texCoord);
vec3 bozlolCol = texture2D(bozlolMap,texCoord).rgb;
vec3 theNorm = normalize(norm);
vec3 refCol = textureCube(envMap,reflect(normalize(eyeVec),normalize(theNorm))).rgb;
vec3 refraVec= refract(normalize(eyeVec),normalize(theNorm),eta);
vec3 refraCol = textureCube(envMap,refraVec).rgb;

float fressy = ((1.0 - eta)*(1.0 - eta))/((1.0 + eta)*(1.0 + eta));
float superFres = fressy + (1.0 - fressy)*pow((1.0-dot(normalize(eyeVec),theNorm)),5.0);

gl_FragColor = vec4(mix(refraCol,refCol,0.3)*col.rgb*(1.0),1.0);

}