uniform extern texture gTexture : XDL2ST_TEXTURE_0;
uniform extern float gX : XDL2SF_CUSTOM_0;
uniform extern float4 gColor : XDL2SV_CUSTOM_0 = float4(1.0f,1.0f,1.0f,1.0f);

sampler sTex_0 = sampler_state
{
	Texture = <gTexture>;
	MinFilter = Linear;
	MagFilter = Linear;
	AddressU = CLAMP;
};

float4 pixelShader(float2 texcoord : TEXCOORD0) : COLOR
{
	if(texcoord.x > gX)
		texcoord.x = gX;
	return tex2D(sTex_0,texcoord)*gColor;
}

technique Fx
{
	Pass P0
	{
		vertexShader = Null;
		pixelShader = compile ps_2_0 pixelShader();
	}
}