uniform extern texture  g_Texture  : XDL2ST_TEXTURE_0;
uniform extern float g_Time : XDL2SF_CUSTOM_0;

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

	MinFilter = LINEAR;
	MagFilter = LINEAR;
	AddressU = Wrap;	
	AddressV = Wrap;
};

float4 pixelShader(float2 texc : TEXCOORD0) : COLOR
{
	tex.x += sin(tex.y*g_Time)*0.1f;
	tex.x += frac(tex.y*g_Time)*0.1f;
	tex.y += frac(tex.x*g_Time)*0.1f;
	
	float4 c = tex2D(texSample,tex);
	return c;
}

technique Fx
{
	Pass P0
	{
		vertexShader = Null;
		pixelShader = compile ps_2_0 pixelShader();
		ZEnable = FALSE;
		ZWriteEnable = FALSE;
	}
}