uniform extern float4x4 g_WVP : XDL2SM_WORLD_VIEW_PROJECTION;

struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float4 col : COLOR0;
};

VertexShaderOut VertexShader(float3 posa : POSITION0, float4 col : COLOR0)
{
	VertexShaderOut vso = (VertexShaderOut)0;
	vso.pos = mul( float4(posa,1.0f), g_WVP );
	vso.col = col;

	return vso;
}

float4 PixelShader(float4 col : COLOR0) : COLOR
{
	return col;
}

technique Shader
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
		//CullMode = None;
		SrcBlend = One;
		DestBlend = One;
		BlendOp = Add;
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
	}
}

