uniform extern float4x4 g_WVPMatrix  : XDL2SM_WORLD_VIEW_PROJECTION;
uniform extern float4x4 g_World	     : XDL2SM_WORLD;
uniform extern float4x4 g_WorldIT    : XDL2SM_WORLD_INVERSE_TRANSPOSE;
uniform extern texture  g_Texture    : XDL2ST_TEXTURE_0;
uniform extern float4   g_Diffuse    : XDL2SV_MATERIAL_DIFFUSE = float4(0.9f,0.9f,1.0f,1.0f);
uniform extern float4   g_Ambient    : XDL2SV_MATERIAL_AMBIENT = float4(0.1f,0.1f,0.1f,1.0f);
uniform extern float	g_Time	     : XDL2SF_CUSTOM_0;

float4 g_EyePos : XDL2SV_EYE_POSITION;


#include "Base/light.fxh"


sampler texSample = sampler_state
{
	Texture = <g_Texture>;

    	MinFilter = Linear;
    	MagFilter = Linear;
};

struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float2 tex  : TEXCOORD0;
	float3 posW : TEXCOORD1;
	float3 norm : TEXCOORD2;
};

VertexShaderOut VertexShader(float3 pos : POSITION0, float3 norm : NORMAL0, float2 tex : TEXCOORD0)
{
	VertexShaderOut vso = (VertexShaderOut)0;
	pos *= 0.1;
	
	float an = sin(5*g_Time+pos.y*0.5)*1;

	float3 ori = pos;
	pos.x += sin(an);
	pos.z += cos(an*1.1);
	
	vso.pos  = mul( float4(pos,1.0f), g_WVPMatrix );
	vso.tex  = tex;
	vso.posW = mul( float4(pos,1.0f), g_World );
	vso.norm = mul( float4(norm,0.0f), g_WorldIT );
	return vso;
}

float4 PixelShader(float2 tex : TEXCOORD0, float3 pos : TEXCOORD1, float3 normal : TEXCOORD2) : COLOR
{
	normal = normalize(normal);
	
	float3 toEye = normalize(g_EyePos-pos);

	float3 lightVec = normalize(float3(0.0f,7.0f,0.0f)-pos);
	float4 pdiff = (LightDiffuse(normal,lightVec));
	float4 pspec = LightSpec(normal,lightVec,toEye,16);

	float4 col = g_Ambient+(g_Diffuse*pdiff)+pspec;
	float4 fin = col;

	return	fin;
}

technique Blocks
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
		//CullMode = None;

		
		//AlphaBlendEnable = TRUE;
		//SrcBlend = SrcAlpha;
		//DestBlend = InvSrcAlpha;
		//BlendOp = Add;
		//ZEnable = FALSE;
	}
}
